use strict;
use utf8;
use parent("Schulkonsole::Error::Error");
package Schulkonsole::Error::DruckquotasError;
require Exporter;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
$VERSION = 0.16;
@ISA = qw(Exporter Schulkonsole::Error::Error);
@EXPORT_OK = qw(
	new
	what

	WRAPPER_INVALID_USER
	WRAPPER_INVALID_ACTION
	WRAPPER_WRONG_ACTION
	WRAPPER_INVALID_VALUE
	WRAPPER_INVALID_USERLIST
	WRAPPER_NO_USERS
	WRAPPER_INVALID_PRINTER
	WRAPPER_INVALID_GROUP
	WRAPPER_INVALID_NUMBER
	WRAPPER_NO_DBPASSWORD
	WRAPPER_UNEXPECTED_DATA
	WRAPPER_INVALID_PAGES
	WRAPPER_INVALID_MAX_PAGES
);

# package constants
use constant {
	WRAPPER_INVALID_USER => Schulkonsole::Error::Error::NEXT_ERROR -1,
	WRAPPER_INVALID_ACTION => Schulkonsole::Error::Error::NEXT_ERROR -2,
	WRAPPER_WRONG_ACTION => Schulkonsole::Error::Error::NEXT_ERROR -3,
	WRAPPER_INVALID_VALUE => Schulkonsole::Error::Error::NEXT_ERROR -4,
	WRAPPER_INVALID_USERLIST => Schulkonsole::Error::Error::NEXT_ERROR -5,
	WRAPPER_NO_USERS => Schulkonsole::Error::Error::NEXT_ERROR -6,
	WRAPPER_INVALID_PRINTER => Schulkonsole::Error::Error::NEXT_ERROR -7,
	WRAPPER_INVALID_GROUP => Schulkonsole::Error::Error::NEXT_ERROR -8,
	WRAPPER_INVALID_NUMBER => Schulkonsole::Error::Error::NEXT_ERROR -9,
	WRAPPER_NO_DBPASSWORD => Schulkonsole::Error::Error::NEXT_ERROR -10,
	WRAPPER_UNEXPECTED_DATA => Schulkonsole::Error::Error::NEXT_ERROR -11,
	WRAPPER_INVALID_PAGES => Schulkonsole::Error::Error::NEXT_ERROR -12,
	WRAPPER_INVALID_MAX_PAGES => Schulkonsole::Error::Error::NEXT_ERROR -13,
};

sub new {
	my $class = shift;
	my $this = $class->SUPER::new(@_);
	bless $this, $class;
	
	return $this;
}

sub _init {
	my $this = shift;
	$this->SUPER::_init(@_);
	$this->{dplugin} = Locale::gettext->domain('linuxmuster-pk-schulkonsole');
	$this->{dplugin}->dir('/usr/share/locale');
}



sub what {
	my $this = shift;
	return $this->{errstr} if $this->{errstr};
	
	SWITCH: {
		$this->{code} == WRAPPER_INVALID_USER and do {
			return $this->{dplugin}->get('Ungültiger Benutzer');
		};
		$this->{code} == WRAPPER_INVALID_ACTION and do {
			return $this->{dplugin}->get('Ungültige Aktion');
		};
		$this->{code} == WRAPPER_WRONG_ACTION and do {
			return $this->{dplugin}->get('Unpassende Aktion');
		};
		$this->{code} == WRAPPER_INVALID_VALUE and do {
			return $this->{dplugin}->get('Ungültiger Wert');
		};
		$this->{code} == WRAPPER_INVALID_USERLIST and do {
			return $this->{dplugin}->get('Ungültige Benutzerliste');
		};
		$this->{code} == WRAPPER_NO_USERS and do {
			return $this->{dplugin}->get('Keine Benutzer vorhanden');
		};
		$this->{code} == WRAPPER_INVALID_PRINTER and do {
			return $this->{dplugin}->get('Ungültiger Drucker');
		};
		$this->{code} == WRAPPER_INVALID_GROUP and do {
			return $this->{dplugin}->get('Ungültige Gruppe');
		};
		$this->{code} == WRAPPER_INVALID_NUMBER and do {
			return $this->{dplugin}->get('Ungültige Zahl');
		};
		$this->{code} == WRAPPER_NO_DBPASSWORD and do {
			return $this->{dplugin}->get('Das Datenbankpassword konnte nicht ermittelt werden');
		};
		$this->{code} == WRAPPER_UNEXPECTED_DATA and do {
			return $this->{dplugin}->get('Unerwartete Programmausgabe');
		};
		$this->{code} == WRAPPER_INVALID_PAGES and do {
			return $this->{d}->get('Ungültige Daten für genutzte Druckquota');
		};
		$this->{code} == WRAPPER_INVALID_MAX_PAGES and do {
			return $this->{d}->get('Ungültige Daten fuer Druckquota');
		};
	};

	return $this->SUPER::what();
}



1;
