#!/bin/bash
# /usr/share/schulkonsole/scripts/update-permissions.sh
# erzeugt die Datei permissions.conf aus den Dateien
# im Verzeichnis permissions.d
# Die Dateinamen in permissions.d sind nach dem Muster:
# gruppe-category-name, dabei ist Gruppe aus
# all, teachers, domadmins und category aus
# permission, program.
# Nach dem zweiten Bindestrich folgt ein eindeutiger Name.
# Dabei überstimmen Dateien aus $PERMUSERDIR
# Dateien aus $PERMDIR.
#
# Frank Schütte, 2015
#
PERMDIR=/usr/lib/schulkonsole/permissions.d
PERMUSERDIR=/etc/linuxmuster/schulkonsole/permissions.d
PERMCONF=/etc/linuxmuster/schulkonsole/permissions.conf
GROUP="all
teachers
domadmins
students"

rm -f $PERMCONF
touch $PERMCONF

cat <<EOF >$PERMCONF
# /etc/linuxmuster/schulkonsole/permissions.conf
# autogenerated - do not edit
# autogenerated by /usr/share/schulkonsole/scripts/update-permissions.sh
#
# Place permissions in subdir permissions.d
# naming group-category-name with
# group one of all, teachers, domadmins
# category one of pages, programs
# A file in /etc/linuxmuster/schulkonsole/permissions.d
# overrides the same file in
# /usr/lib/schulkonsole/permissions.d
#
EOF
DATE=`date`
echo # $DATE >>$PERMCONF

# write pages
  echo "[Pages]" >>$PERMCONF
  for g in $GROUP; do
    FILES=$(find $PERMDIR $PERMUSERDIR -name "$g-pages-*" -printf '%f\n'|sort -u)
    echo "Pagefiles: [$FILES]"|tr '\n' ' '
    echo
    for f in $FILES; do
      ff=$PERMDIR/$f
      [ -e $PERMUSERDIR/$f ] && ff=$PERMUSERDIR/$f
      cat $ff>>$PERMCONF
    done;
  done;

# write programs
  echo >>$PERMCONF
  echo "[External Programs]" >>$PERMCONF
  for g in $GROUP; do
    FILES=$(find $PERMDIR $PERMUSERDIR -name "$g-programs-*" -printf '%f\n'|sort -u)
    echo "Programs: [$FILES]"|tr '\n' ' '
    echo
    for f in $FILES; do
      ff=$PERMDIR/$f
      [ -e $PERMUSERDIR/$f ] && ff=$PERMUSERDIR/$f
      cat $ff>>$PERMCONF
    done;
  done;

chown www-data.www-data $PERMCONF
