# $Id$
package coldformix;


######################################################################
# SUBS
######################################################################

sub get_symbols{
    # read all entrys of the table
    my %symbols=();
    my $row;
    my $name;

    my $dbh = DBI->connect("dbi:mysql:coldformix", "coldformix", "coldformix",
                   { RaiseError => 1, AutoCommit => 1 });

    my $sth = $dbh->prepare("SELECT * FROM symbols");
       $sth->execute();
    
    while ($row = $sth->fetchrow_hashref()) {
         $name=$row->{'name'};
         $symbols{$name} = { %$row };
    }

    $dbh->disconnect;
    return %symbols;
}



sub get_substances{
    # read all entrys of the table
    my %substances=();
    my $row;
    my $name;

    my $dbh = DBI->connect("dbi:mysql:coldformix", "coldformix", "coldformix",
                   { RaiseError => 1, AutoCommit => 1 });

    my $sth = $dbh->prepare("SELECT * FROM substances");
       $sth->execute();
    
    while ($row = $sth->fetchrow_hashref()) {
         $name=$row->{'name'};
         $substances{$name} = { %$row };
    }

    $dbh->disconnect;
    return %substances;
}


sub get_refrig{
    # read all entrys of the table
    my %refrig=();
    my $row;
    my $name;

    my $dbh = DBI->connect("dbi:mysql:coldformix", "coldformix", "coldformix",
                   { RaiseError => 1, AutoCommit => 1 });

    my $sth = $dbh->prepare("SELECT * FROM refrigerants");
       $sth->execute();
    
    while ($row = $sth->fetchrow_hashref()) {
         $name=$row->{'name'};
         $refrig{$name} = { %$row };
    }

    $dbh->disconnect;
    return %refrig;
}



sub get_oils{
    # read all entrys of the table
    my %oils=();
    my $row;
    my $name;

    my $dbh = DBI->connect("dbi:mysql:coldformix", "coldformix", "coldformix",
                   { RaiseError => 1, AutoCommit => 1 });

    my $sth = $dbh->prepare("SELECT * FROM oils");
       $sth->execute();
    
    while ($row = $sth->fetchrow_hashref()) {
         $name=$row->{'name'};
         $oils{$name} = { %$row };
    }

    $dbh->disconnect;
    return %oils;
}






sub get_filename_refrigerants{
    # read all entrys of the table refrigerants
    my %refrigerants=();
    my $row;
    my $name;

    my $dbh = DBI->connect("dbi:mysql:coldformix", "coldformix", "coldformix",
                   { RaiseError => 1, AutoCommit => 1 });

    my $sth = $dbh->prepare("SELECT * FROM refrigerants");
       $sth->execute();
    
    while ($row = $sth->fetchrow_hashref()) {
         $name=$row->{'filename'};
         $refrigerants{$name} = { %$row };
    }

    $dbh->disconnect;
    return %refrigerants;
}





sub get_units {
    # read all entrys of the table
    my %units=();
    my $row;
    my $unit;

    my $dbh = DBI->connect("dbi:mysql:coldformix", "coldformix", "coldformix",
                   { RaiseError => 1, AutoCommit => 1 });

    my $sth = $dbh->prepare("SELECT * FROM units");
       $sth->execute();

    while ($row = $sth->fetchrow_hashref()) {
         $unit=$row->{'unit'};
         $units{$unit} = { %$row };
    }

    $dbh->disconnect;
    return %units;
}






sub get_trans {
    # read all entrys of the table
    my %trans=();
    my $row;
    my $unit;
#    my $trans;

    my $dbh = DBI->connect("dbi:mysql:coldformix", "coldformix", "coldformix",
                   { RaiseError => 1, AutoCommit => 1 });

    my $sth = $dbh->prepare("SELECT * FROM vocabulary");
       $sth->execute();

    while ($row = $sth->fetchrow_hashref()) {
         $unit=$row->{'de'};
         $trans{$unit} = { %$row };
    }

    $dbh->disconnect;
    return %trans;
}




#sub explain_symbol {
#    my ($name,$number) = @_;
#    my $lang_column = "$lang"."_short";
#    my $latex_column = "latex_"."$number";
#    my $description="";
#    my $latex_line="";
#    if (not defined $symbols{$name}{$lang_column}
#        or $symbols{$name}{$lang_column} eq ""){
#	$description = "\\textcolor{red}{$symbols{$name}{'de_short'}(de)}";
#	print "Not defined!\n"; 
#    } else {
#	$description = $symbols{$name}{$lang_column};
#    }
#    my $unit = $units{$symbols{$name}{'unit'}}{$latex_column};
#    print "Looking in column $lang_column for explanation of $name \n";
#    print "-> Hit:  $symbols{$name}{$lang_column} \n";
#    print "Basic unit of $name is ->  $symbols{$name}{'unit'}\n";
#    print "Unit in latex_$number  is ->  $unit \n";
#
##    print LATEXOUT "\\item [\$$symbols{$name}{$unit_system}\$]:",
##                   " $description in $unit\n";
#
#    $latex_line = "\\item [\$$symbols{$name}{$unit_system}\$]:".
#                  " $description in $unit\n";
#    return $latex_line;
#}









# Diese Subroutine bekommt als Argment den Parsewert der Funktion GetOptions.
# Ist dieser nicht 1, so wurde eine Fehlerhafte Option vergeben
sub  check_options{
   my ($parse_ergebnis) = @_;
   if (not $parse_ergebnis==1){
      my @list = split(/\//,$0);
      my $scriptname = pop @list;
      print "\nSie haben bei der Eingabe der Optionen einen Fehler begangen.\n"; 
      print "Siehe Fehlermeldung weiter oben. \n\n";
      print "... $scriptname beendet sich.\n\n";
      exit;
   } else {
         print "Alle Befehls-Optionen wurden erkannt.\n";
   }

}








sub read_contributors {
  # reads the file of contributors,
  # and puts the lines in an ascibetical list
  my @contributors=();
  open(CONTRIB, "<../README/contributors.txt");
  while(<CONTRIB>){
     chomp();
     if ($_ eq ""){next;} # Wenn Zeile Leer, dann aussteigen
     if(/^\#/){next;} # Bei Kommentarzeichen aussteigen
     push @contributors, $_;
  }
  @contributors = sort @contributors;
  close(CONTRIB);
  return @contributors;
}


sub read_error_contributors {
  # reads the file of error contributors,
  # and puts the lines in an ascibetical list
  my @e_contributors=();
  open(ERRORCONTRIB, "<../README/error-contributors.txt");
  while(<ERRORCONTRIB>){
     chomp();
     if ($_ eq ""){next;} # Wenn Zeile Leer, dann aussteigen
     if(/^\#/){next;} # Bei Kommentarzeichen aussteigen
     push @e_contributors, $_;
  }
  @e_contributors = sort @e_contributors;
  close(ERRORCONTRIB);
  return @e_contributors;
}





# ===========================================================================
# Beliebige Liste mit beliebigem Trennzeichen in einen String schreiben
# ===========================================================================
sub format_list {
   my ($trenner,@liste) = @_;
   # print "Trenner $trenner  Liste: -@liste-\n\n";
   my $on_off=0;
   my $returnstring="";
   my $listitem="";
   foreach $listitem (@liste) {
      if ($listitem eq "") {
         next;
      }
      if ($on_off==0) {
         # erster Durchlauf
         $returnstring=$listitem;
         $on_off=1;
      } else {
         # weitere Durchlufe
         $returnstring="$returnstring"."$trenner"."$listitem";
      }
   }
   # print "Ret: $returnstring\n";
   return $returnstring;
 }





# Eine Komma-Zahl von Nullen am Ende Befreien
sub strip {
    my ($value)= @_;
    if (defined $value){
       while ($value=~/0$/){
	   $value=~s/0$//;
       }

       if ($value=~/\.$/){
           $value=~s/\.$//
       }

       if ($value=~/,$/){
           $value=~s/,$//
       }

       return $value;
   }
}



# check if a value is defined, then strip it, otherwise return ""
sub checkdef {
    my ($field, $mode)=@_;
    if (not defined $mode) {
	$mode="";
    }
    if (defined $field) {
        if ($mode ne "string") {
           $field=&coldformix::strip($field);
        }
	return $field;
    } else {
	$field="";
	return $field;
    }
    
}



# add a + sign, depending on the value
# put it in mathematical mode
sub sign {
    my ($value) = @_;
    if (defined $value and $value ne ""){
      if ($value>0){
#         $value="\$+".$value."\$";
         $value="+".$value;
      } elsif ($value<0){
#         $value="\$".$value."\$";
#         $value="\$".$value."\$";
      }
      return $value;
  } else {
      return 999999;
  }
} 



sub translate {
    my ($word, $lang, $transhash) = @_;
    my %translation=%$transhash;
    my $newword="";
    print "Translating $word to language: $lang  using $transhash: ";

    if (defined $translation{$word}{$lang}  && $translation{$word}{$lang} ne "") {
        $newword=$translation{$word}{$lang};
    } else {
        if (exists $translation{$word}{'de'}){
           $newword="\\textcolor{red}{"."$translation{$word}{'de'}"."(de)}";
       } else {
           $newword="\\textcolor{blue}{"."$word"."(No Database entry!)}";
       }
    }
    print "Result: $newword \n";
    return $newword;
}
#sub translate {
#    my ($word, $lang, $transhash) = @_;
#    my %translation=%{ $transhash };
#    my $newword="";
#    print "Translating $word to language: $lang  using $transhash: ";
#
#    if (defined $translation{$word}{$lang}  && $translation{$word}{$lang} ne "") {
#        $newword=$translation{$word}{$lang};
#    } else {
#        $newword="\\textcolor{red}{"."$translation{$word}{'de'}"."(de)}";
#    }
#    print "Result: $newword \n";
#    return $newword;
#}





sub explain_symbol {
    my ($name,$number) = @_;
    my $lang_column = "$lang";
    my $latex_column = "latex_"."$number";
    my $description="";
    my $latex_line="";
    if (not defined $symbols{$name}{$lang_column}
        or $symbols{$name}{$lang_column} eq ""){
	$description = "\\textcolor{red}{$symbols{$name}{'de'}(de)}";
	print "Not defined!\n"; 
    } else {
	$description = $symbols{$name}{$lang_column};
    }
    my $unit = $units{$symbols{$name}{'unit'}}{$latex_column};
    print "Looking in column $lang_column for explanation of $name \n";
    print "-> Hit:  $symbols{$name}{$lang_column} \n";
    print "Basic unit of $name is ->  $symbols{$name}{'unit'}\n";
    print "Unit in latex_$number  is ->  $unit \n";

    $latex_line = "\\item [\$$symbols{$name}{$unit_system}\$]:".
                  " $description in $unit\n";
    return $latex_line;
}



print "   ... Module coldformix loaded\n";
# return 1 for successful loading
1;
