#!/usr/bin/python3
#
# general setup
# thomas@linuxmuster.net
# 20200306
#

import constants
import os
import sys
import configparser

from dialog import Dialog
from functions import detectedInterfaces
from functions import isValidHostname
from functions import isValidDomainname
from functions import isValidHostIpv4
from functions import isValidPassword
from functions import printScript
from functions import subProc
from IPy import IP

title = os.path.basename(__file__).replace('.py', '').split('_')[1]
logfile = constants.LOGDIR + '/setup.' + title + '.log'

printScript('', 'begin')
printScript(title)

# read setup ini
msg = 'Reading setup data '
printScript(msg, '', False, False, True)
setupini = constants.SETUPINI
try:
    setup = configparser.RawConfigParser(delimiters=('='), inline_comment_prefixes=('#', ';'))
    setup.read(setupini)
    serverip = setup.get('setup', 'serverip')
    servername = setup.get('setup', 'servername')
    domainname = setup.get('setup', 'domainname')
    printScript(' Success!', '', True, True, False, len(msg))
except:
    printScript(' Failed!', '', True, True, False, len(msg))
    sys.exit(1)

# get network interfaces
# iface_list, iface_default = detectedInterfaces()

# begin dialog
title = 'linuxmuster.net 7: Setup for ' + servername + '.' + domainname + '\n\n'
dialog = Dialog(dialog="dialog")
dialog.set_background_title(title)
button_names = {dialog.OK:     "OK",
                dialog.CANCEL: "Cancel"}

"""
# schoolname
rc, schoolname = dialog.inputbox('Bitte geben Sie den Schulnamen ein:', height=16, width=64, init=setup.get('setup', 'schoolname'))
if rc == 'cancel':
    sys.exit(1)

print('Schulname: ' + schoolname)
setup.set('setup', 'schoolname', schoolname )

# location
rc, location = dialog.inputbox('Bitte geben Sie den Schulort ein:', height=16, width=64, init=setup.get('setup', 'location'))
if rc == 'cancel':
    sys.exit(1)

print('Schulort: ' + location)
setup.set('setup', 'location', location )

# country
rc, country = dialog.inputbox('Bitte geben Sie das Land in Kurzform ein:', height=16, width=64, init=setup.get('setup', 'country'))
if rc == 'cancel':
    sys.exit(1)
country = country.upper()[0:2]
print('Land: ' + country)
setup.set('setup', 'country', country )

# state
rc, state = dialog.inputbox('Bitte geben Sie das Bundesland ein:', height=16, width=64, init=setup.get('setup', 'state'))
if rc == 'cancel':
    sys.exit(1)

print('Bundesland: ' + state)
setup.set('setup', 'state', state )

# sambadomain
sambadomain = domainname.split('.')[0].upper()
print('Samba domain: ' + sambadomain)
setup.set('setup', 'sambadomain', sambadomain)
"""

# servername
ititle = title + ': Servername'
while True:
    rc, servername = dialog.inputbox('Enter the hostname of the main server:', title=ititle, height=16, width=64, init=setup.get('setup', 'servername'))
    if rc == 'cancel':
        sys.exit(1)
    if isValidHostname(servername):
        break

print('Server hostname: ' + servername)
setup.set('setup', 'servername', servername)
setup.set('setup', 'hostname', servername)
netbiosname = servername.upper()
print('Netbios name: ' + netbiosname)
setup.set('setup', 'netbiosname', netbiosname)

# domainname
ititle = title + ': Domainname'
while True:
    rc, domainname = dialog.inputbox('Note that the first part of the domain name is used automatically as samba domain (maximal 15 characters using a-z and "-"). Use a prepending "linuxmuster" if your domain has more characters. Enter the internet domain name:', title=ititle, height=16, width=64, init=domainname)
    if rc == 'cancel':
        sys.exit(1)
    if isValidDomainname(domainname):
        break

print('Domain name: ' + domainname)
setup.set('setup', 'domainname', domainname)
basedn = 'DC=' + domainname.replace('.', ',DC=')
print('BaseDN: ' + basedn)
setup.set('setup', 'basedn', basedn)
realm = domainname.upper()
print('REALM: ' + realm)
setup.set('setup', 'realm', realm)
sambadomain = realm.split('.')[0]
print('Sambadomain: ' + sambadomain)
setup.set('setup', 'sambadomain', sambadomain)


# dhcprange
ititle = title + ': DHCP Range'
dhcprange1 = serverip.split('.')[0] + '.' + serverip.split('.')[1] + '.' + serverip.split('.')[2] + '.' + '100'
dhcprange2 = serverip.split('.')[0] + '.' + serverip.split('.')[1] + '.' + serverip.split('.')[2] + '.' + '200'
dhcprange = dhcprange1 + ' ' + dhcprange2
while True:
    rc, dhcprange = dialog.inputbox('Enter the two ip addresses for the free dhcp range (space separated):', title=ititle, height=16, width=64, init=dhcprange)
    if rc == 'cancel':
        sys.exit(1)
    dhcprange1 = dhcprange.split(' ')[0]
    dhcprange2 = dhcprange.split(' ')[1]
    if isValidHostIpv4(dhcprange1) and isValidHostIpv4(dhcprange2):
        break
print('DHCP range: ' + dhcprange)
setup.set('setup', 'dhcprange', dhcprange)

# opsi
ititle = title + ': Opsi-IP'
try:
    opsiip=setup.get('setup', 'opsiip')
except:
    opsiip = ''
while True:
    rc, opsiip = dialog.inputbox('Enter the ip address of the opsi server (optional):', title=ititle, height=16, width=64, init=opsiip)
    if rc == 'cancel':
        sys.exit(1)
    if opsiip == '' or isValidHostIpv4(opsiip):
        break
print('Opsi ip: ' + opsiip)
setup.set('setup', 'opsiip', opsiip)

# dockerip
ititle = title + ': Dockerhost-IP'
try:
    dockerip=setup.get('setup', 'dockerip')
except:
    dockerip = ''
while True:
    rc, dockerip = dialog.inputbox('Enter the ip address of the docker host (optional):', title=ititle, height=16, width=64, init=dockerip)
    if rc == 'cancel':
        sys.exit(1)
    if isValidHostIpv4(dockerip) or dockerip == '':
        break
print('Docker host ip: ' + dockerip)
setup.set('setup', 'dockerip', dockerip)

# mail
nostatus = False
servermail = False
dockermail = False
ititle = title + ': Mailserver IP'
try:
    mailip=setup.get('setup', 'mailip')
    if isValidHostIpv4(mailip) and mailip == serverip:
        servermail = True
    elif isValidHostIpv4(mailip) and mailip == dockerip:
        dockermail = True
except:
    mailip = ''
    nostatus = True
while True:
    if dockerip != '':
        rc, mailip = dialog.radiolist('Enter the ip address of the mail server (optional):', title=ititle, height=16, width=64, list_height=3, choices=[('', 'no mailserver', nostatus), (serverip, 'use server ip', servermail), (dockerip, 'use docker ip', dockermail)])
    else:
        rc, mailip = dialog.radiolist('Enter the ip address of the mail server (optional):', title=ititle, height=16, width=64, list_height=3, choices=[('', 'no mailserver', nostatus), (serverip, 'use server ip', servermail)])
    #rc, mailip = dialog.inputbox('Enter the ip address of the mail server (optional):', title=ititle, height=16, width=64, init=mailip)
    if rc == 'cancel':
        sys.exit(1)
    if mailip == '' or isValidHostIpv4(mailip):
        break
print('Mail ip: ' + mailip)
setup.set('setup', 'mailip', mailip)

# smtp access data
if mailip != '':
    # smtp relay ip of fully qualified domain name
    ititle = title + ': SMTP Relay'
    try:
        smtprelay_full = setup.get('setup', 'smtprelay')
    except:
        smtprelay_full = ''
    while True:
        rc, smtprelay_full = dialog.inputbox('Enter the ip address or fqdn and port of the smtp relay, eg. mail.example.com:587 (optional). If port is omitted default port 25 is used. :', title=ititle, height=16, width=64, init=smtprelay_full)
        if rc == 'cancel':
            sys.exit(1)
        # split relay address and port
        smtprelay = smtprelay_full.split(':')[0]
        try:
            smtpport = smtprelay_full.split(':')[1]
        except:
            smtpport = '25'
        # test valid relay address
        if (isValidHostIpv4(smtprelay) or isValidDomainname(smtprelay) or smtprelay == ''):
            smtprelay_ok = True
        else:
            smtprelay_ok = False
        # test valid port nr
        try:
            smtpport_nr = int(smtpport)
            smtpport_ok = True
        except:
            smtpport_ok = False
        if smtprelay_ok is True and smtpport_ok is True:
            break
    print('SMTP relay: ' + smtprelay + ':' + smtpport)
    setup.set('setup', 'smtprelay', smtprelay_full)
    # ask only if smtprelay is set
    if smtprelay_full != '':
        # smtp user
        ititle = title + ': SMTP Username'
        try:
            smtpuser=setup.get('setup', 'smtpuser')
        except:
            smtpuser = ''
        while True:
            rc, smtpuser = dialog.inputbox('Enter the name of the smtp user:', title=ititle, height=16, width=64, init=smtpuser)
            if rc == 'cancel':
                sys.exit(1)
            if smtpuser != '':
                break
        print('SMTP Username: ' + smtpuser)
        setup.set('setup', 'smtpuser', smtpuser)
        # smtp password
        ititle = title + ': SMTP Password'
        try:
            smtppw=setup.get('setup', 'smtppw')
        except:
            smtppw = ''
        while True:
            rc, smtppw = dialog.inputbox('Enter the password of the smtp user:', title=ititle, height=16, width=64, init=smtppw)
            if rc == 'cancel':
                sys.exit(1)
            if smtppw != '':
                break
        print('SMTP Password: ' + smtppw)
        setup.set('setup', 'smtppw', smtppw)

# global admin password
ititle = title + ': Administrator password'
adminpw = ''
adminpw_repeated = ''
while True:
    rc, adminpw = dialog.passwordbox('Enter the Administrator password (Note: Input will be unvisible!). Minimal length is 7 characters. Use upper and lower and special characters or numbers (e.g. mUster!):', title=ititle, insecure=True)
    if rc == 'cancel':
        sys.exit(1)
    if isValidPassword(adminpw):
        while True:
            rc, adminpw_repeated = dialog.passwordbox('Re-enter the Administrator password:', title=ititle, insecure=True)
            if rc == 'cancel':
                sys.exit(1)
            if isValidPassword(adminpw_repeated):
                break
    if adminpw == adminpw_repeated:
        break

print('Administrator password: ' + adminpw)
setup.set('setup', 'adminpw', adminpw)

# write INIFILE
msg = 'Writing input to setup ini file '
printScript(msg, '', False, False, True)
try:
    with open(constants.SETUPINI, 'w') as INIFILE:
        setup.write(INIFILE)
    printScript(' Success!', '', True, True, False, len(msg))
except:
    printScript(' Failed!', '', True, True, False, len(msg))
    sys.exit(1)

# set root password
msg = 'Setting root password '
printScript(msg, '', False, False, True)
try:
    subProc('echo "root:' + adminpw + '" | chpasswd', logfile)
    if os.path.isdir('/home/linuxmuster'):
        subProc('echo "linuxmuster:' + adminpw + '" | chpasswd', logfile)
    printScript(' Success!', '', True, True, False, len(msg))
except:
    printScript(' Failed!', '', True, True, False, len(msg))
    sys.exit(1)
