// Generated by CoffeeScript 2.4.1
(function() {
  angular.module('lm.users', ['core', 'lm.common']);

}).call(this);

// Generated by CoffeeScript 2.4.1
(function() {
  angular.module('lm.users').config(function($routeProvider) {
    return $routeProvider.when('/view/lm/users/teachers', {
      controller: 'LMUsersTeachersController',
      templateUrl: '/lmn_users:resources/partial/teachers.html'
    });
  });

  angular.module('lm.users').controller('LMUsersTeachersController', function($scope, $http, $location, $route, $uibModal, gettext, notify, messagebox, pageTitle, lmFileEditor, lmEncodingMap) {
    pageTitle.set(gettext('Teachers'));
    $scope.sorts = [
      {
        name: gettext('First name'),
        fx: function(x) {
          return x.givenName;
        }
      },
      {
        name: gettext('Last name'),
        fx: function(x) {
          return x.sn;
        }
      },
      {
        name: gettext('Login'),
        fx: function(x) {
          return x.sAMAccountName;
        }
      },
      {
        name: gettext('Birthday'),
        fx: function(x) {
          return x.sophomorixBirthdate;
        }
      },
      {
        name: gettext('Status'),
        fx: function(x) {
          return x.sophomorixStatus.tag;
        }
      }
    ];
    $scope.sort = $scope.sorts[0];
    $scope.paging = {
      page: 1,
      pageSize: 50
    };
    $scope.all_selected = false;
    $scope.query = '';
    $http.post('/api/lm/sophomorixUsers/teachers', {
      action: 'get-all'
    }).then(function(resp) {
      $scope.teachers = resp.data;
      return console.log(resp.data);
    });
    $scope.showInitialPassword = function(users) {
      var type, user;
      user = [];
      user[0] = users[0]["sAMAccountName"];
      // function needs an array which contains user on first position
      type = gettext('Initial password');
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/showPassword.modal.html',
        controller: 'LMNUsersShowPasswordController',
        resolve: {
          user: function() {
            return user;
          },
          type: function() {
            return type;
          }
        }
      });
    };
    $scope.teachersQuota = false;
    $scope.getQuotas = function() {
      var t, teacherList;
      teacherList = (function() {
        var i, len, ref, results;
        ref = $scope.teachers;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          t = ref[i];
          results.push(t.sAMAccountName);
        }
        return results;
      })();
      return $http.post('/api/lm/users/get-group-quota', {
        groupList: teacherList
      }).then(function(resp) {
        $scope.teachersQuota = resp.data;
        return console.log($scope.teachersQuota);
      });
    };
    $scope.setInitialPassword = function(user) {
      var x;
      return $http.post('/api/lm/users/password', {
        users: (function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })(),
        action: 'set-initial'
      }).then(function(resp) {
        return notify.success(gettext('Initial password set'));
      });
    };
    $scope.setRandomPassword = function(user) {
      var x;
      return $http.post('/api/lm/users/password', {
        users: (function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })(),
        action: 'set-random'
      }).then(function(resp) {
        return notify.success(gettext('Random password set'));
      });
    };
    $scope.setCustomPassword = function(user, type) {
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/customPassword.modal.html',
        controller: 'LMNUsersCustomPasswordController',
        size: 'mg',
        resolve: {
          users: function() {
            return user;
          },
          type: function() {
            return type;
          }
        }
      });
    };
    $scope.userInfo = function(user) {
      console.log(user);
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/userDetails.modal.html',
        controller: 'LMNUserDetailsController',
        size: 'lg',
        resolve: {
          id: function() {
            return user[0]['sAMAccountName'];
          },
          role: function() {
            return 'teachers';
          }
        }
      });
    };
    $scope.haveSelection = function() {
      var i, len, ref, x;
      if ($scope.teachers) {
        ref = $scope.teachers;
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            return true;
          }
        }
      }
      return false;
    };
    $scope.batchSetInitialPassword = function() {
      var x;
      return $scope.setInitialPassword((function() {
        var i, len, ref, results;
        ref = $scope.teachers;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.batchSetRandomPassword = function() {
      var x;
      return $scope.setRandomPassword((function() {
        var i, len, ref, results;
        ref = $scope.teachers;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.batchSetCustomPassword = function() {
      var x;
      return $scope.setCustomPassword((function() {
        var i, len, ref, results;
        ref = $scope.teachers;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.filter = function(row) {
      var i, len, ref, result, value;
      // Only query sAMAccountName, givenName and sn
      result = false;
      ref = ['sAMAccountName', 'givenName', 'sn'];
      for (i = 0, len = ref.length; i < len; i++) {
        value = ref[i];
        result = result || row[value].toLowerCase().indexOf($scope.query.toLowerCase() || '') !== -1;
      }
      return result;
    };
    return $scope.selectAll = function(query) {
      var i, len, ref, results, teacher;
      if (query == null) {
        query = '';
      }
      ref = $scope.teachers;
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        teacher = ref[i];
        if (query === void 0 || query === '') {
          teacher.selected = $scope.all_selected;
        }
        if (teacher.sn.toLowerCase().includes(query.toLowerCase())) {
          teacher.selected = $scope.all_selected;
        }
        if (teacher.givenName.toLowerCase().includes(query.toLowerCase())) {
          teacher.selected = $scope.all_selected;
        }
        if (teacher.sophomorixAdminClass.toLowerCase().includes(query.toLowerCase())) {
          teacher.selected = $scope.all_selected;
        }
        if (teacher.sAMAccountName.toLowerCase().includes(query.toLowerCase())) {
          results.push(teacher.selected = $scope.all_selected);
        } else {
          results.push(void 0);
        }
      }
      return results;
    };
  });

}).call(this);

// Generated by CoffeeScript 2.4.1
(function() {
  angular.module('lm.users').config(function($routeProvider) {
    return $routeProvider.when('/view/lm/users/students', {
      controller: 'LMUsersStudentsController',
      templateUrl: '/lmn_users:resources/partial/students.html'
    });
  });

  angular.module('lm.users').controller('LMUsersStudentsController', function($scope, $http, $location, $route, $uibModal, gettext, notify, messagebox, pageTitle, lmFileEditor, lmEncodingMap) {
    pageTitle.set(gettext('Students'));
    $scope.sorts = [
      {
        name: gettext('Class'),
        fx: function(x) {
          return x.sophomorixAdminClass;
        }
      },
      {
        name: gettext('First name'),
        fx: function(x) {
          return x.givenName;
        }
      },
      {
        name: gettext('Last name'),
        fx: function(x) {
          return x.sn;
        }
      },
      {
        name: gettext('Birthday'),
        fx: function(x) {
          return x.sophomorixBirthdate;
        }
      },
      {
        name: gettext('Status'),
        fx: function(x) {
          return x.sophomorixStatus.tag;
        }
      }
    ];
    $scope.sort = $scope.sorts[0];
    $scope.paging = {
      page: 1,
      pageSize: 50
    };
    $scope.all_selected = false;
    $scope.query = '';
    $http.post('/api/lm/sophomorixUsers/students', {
      action: 'get-all'
    }).then(function(resp) {
      return $scope.students = resp.data;
    });
    $scope.showInitialPassword = function(users) {
      var type, user;
      console.log(users);
      user = [];
      user[0] = users[0]["sAMAccountName"];
      // function needs an array which contains user on first position
      type = gettext('Initial password');
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/showPassword.modal.html',
        controller: 'LMNUsersShowPasswordController',
        resolve: {
          user: function() {
            return user;
          },
          type: function() {
            return type;
          }
        }
      });
    };
    $scope.setInitialPassword = function(user) {
      var x;
      return $http.post('/api/lm/users/password', {
        users: (function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })(),
        action: 'set-initial'
      }).then(function(resp) {
        return notify.success(gettext('Initial password set'));
      });
    };
    $scope.setRandomPassword = function(user) {
      var x;
      return $http.post('/api/lm/users/password', {
        users: (function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })(),
        action: 'set-random'
      }).then(function(resp) {
        return notify.success(gettext('Random password set'));
      });
    };
    $scope.setCustomPassword = function(user, type) {
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/customPassword.modal.html',
        controller: 'LMNUsersCustomPasswordController',
        size: 'mg',
        resolve: {
          users: function() {
            return user;
          },
          type: function() {
            return type;
          }
        }
      });
    };
    $scope.userInfo = function(user) {
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/userDetails.modal.html',
        controller: 'LMNUserDetailsController',
        size: 'lg',
        resolve: {
          id: function() {
            return user[0]['sAMAccountName'];
          },
          role: function() {
            return 'students';
          }
        }
      });
    };
    $scope.haveSelection = function() {
      var i, len, ref, x;
      if ($scope.students) {
        ref = $scope.students;
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            return true;
          }
        }
      }
      return false;
    };
    $scope.batchSetInitialPassword = function() {
      var x;
      return $scope.setInitialPassword((function() {
        var i, len, ref, results;
        ref = $scope.students;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.batchSetRandomPassword = function() {
      var x;
      return $scope.setRandomPassword((function() {
        var i, len, ref, results;
        ref = $scope.students;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.batchSetCustomPassword = function() {
      var x;
      return $scope.setCustomPassword((function() {
        var i, len, ref, results;
        ref = $scope.students;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.filter = function(row) {
      var i, len, ref, result, value;
      // Only query sAMAccountName, givenName, sn and sophomorixAdminClass
      result = false;
      ref = ['sAMAccountName', 'givenName', 'sn', 'sophomorixAdminClass'];
      for (i = 0, len = ref.length; i < len; i++) {
        value = ref[i];
        result = result || row[value].toLowerCase().indexOf($scope.query.toLowerCase() || '') !== -1;
      }
      return result;
    };
    return $scope.selectAll = function(query) {
      var i, len, ref, results, student;
      if (query == null) {
        query = '';
      }
      ref = $scope.students;
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        student = ref[i];
        if (query === void 0 || query === '') {
          student.selected = $scope.all_selected;
        }
        if (student.sn.toLowerCase().includes(query.toLowerCase())) {
          student.selected = $scope.all_selected;
        }
        if (student.givenName.toLowerCase().includes(query.toLowerCase())) {
          student.selected = $scope.all_selected;
        }
        if (student.sophomorixAdminClass.toLowerCase().includes(query.toLowerCase())) {
          student.selected = $scope.all_selected;
        }
        if (student.sAMAccountName.toLowerCase().includes(query.toLowerCase())) {
          results.push(student.selected = $scope.all_selected);
        } else {
          results.push(void 0);
        }
      }
      return results;
    };
  });

}).call(this);

// Generated by CoffeeScript 2.4.1
(function() {
  angular.module('lm.users').config(function($routeProvider) {
    return $routeProvider.when('/view/lm/users/schooladmins', {
      controller: 'LMUsersSchooladminsController',
      templateUrl: '/lmn_users:resources/partial/schooladmins.html'
    });
  });

  angular.module('lm.users').controller('LMUsersSchooladminsController', function($scope, $http, $location, $route, $uibModal, gettext, notify, messagebox, pageTitle, lmFileEditor, lmEncodingMap) {
    pageTitle.set(gettext('Schooladmins'));
    $scope.sorts = [
      {
        name: gettext('Login'),
        fx: function(x) {
          return x.sAMAccountName;
        }
      }
    ];
    $scope.sort = $scope.sorts[0];
    $scope.paging = {
      page: 1,
      pageSize: 50
    };
    $scope.all_selected = false;
    $http.post('/api/lm/sophomorixUsers/schooladmins', {
      action: 'get-all'
    }).then(function(resp) {
      return $scope.schooladmins = resp.data;
    });
    $scope.showInitialPassword = function(user) {
      var x;
      return $http.post('/api/lm/users/password', {
        users: (function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })(),
        action: 'get'
      }).then(function(resp) {
        return $http.get('/api/lm/users/test-first-password/' + user[0]['sAMAccountName']).then(function(response) {
          var msg;
          if (response.data === true) {
            msg = gettext('Initial password (still set)');
          } else {
            msg = gettext('Initial password (changed from user)');
          }
          return messagebox.show({
            title: msg,
            text: resp.data,
            positive: 'OK'
          });
        });
      });
    };
    $scope.setInitialPassword = function(user) {
      var x;
      return $http.post('/api/lm/users/password', {
        users: (function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })(),
        action: 'set-initial'
      }).then(function(resp) {
        return notify.success(gettext('Initial password set'));
      });
    };
    $scope.setRandomPassword = function(user) {
      var x;
      return $http.post('/api/lm/users/password', {
        users: (function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })(),
        action: 'set-random'
      }).then(function(resp) {
        return notify.success(gettext('Random password set'));
      });
    };
    $scope.setCustomPassword = function(user, type) {
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/customPassword.modal.html',
        controller: 'LMNUsersCustomPasswordController',
        size: 'mg',
        resolve: {
          users: function() {
            return user;
          },
          type: function() {
            return type;
          }
        }
      });
    };
    $scope.deleteSchoolAdmin = function(user) {
      var x;
      return messagebox.show({
        title: gettext('Delete User'),
        text: gettext("Delete school-administrator " + ((function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })()) + '?'),
        positive: 'Delete',
        negative: 'Cancel'
      }).then(function() {
        return $http.post('/api/lm/users/change-school-admin', {
          users: (function() {
            var i, len, results;
            results = [];
            for (i = 0, len = user.length; i < len; i++) {
              x = user[i];
              results.push(x['sAMAccountName']);
            }
            return results;
          })(),
          action: 'delete'
        }).then(function(resp) {
          $route.reload();
          return notify.success(gettext('User deleted'));
        });
      });
    };
    $scope.addSchoolAdmin = function() {
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/addAdmin.modal.html',
        controller: 'LMNUsersAddAdminController',
        size: 'mg',
        resolve: {
          role: function() {
            return 'school-admin';
          }
        }
      });
    };
    $scope.userInfo = function(user) {
      console.log(user);
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/userDetails.modal.html',
        controller: 'LMNUserDetailsController',
        size: 'lg',
        resolve: {
          id: function() {
            return user[0]['sAMAccountName'];
          },
          role: function() {
            return 'schooladmins';
          }
        }
      });
    };
    $scope.haveSelection = function() {
      var i, len, ref, x;
      if ($scope.schooladmins) {
        ref = $scope.schooladmins;
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            return true;
          }
        }
      }
      return false;
    };
    $scope.batchSetInitialPassword = function() {
      var x;
      return $scope.setInitialPassword((function() {
        var i, len, ref, results;
        ref = $scope.schooladmins;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.batchSetRandomPassword = function() {
      var x;
      return $scope.setRandomPassword((function() {
        var i, len, ref, results;
        ref = $scope.schooladmins;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.batchSetCustomPassword = function() {
      var x;
      return $scope.setCustomPassword((function() {
        var i, len, ref, results;
        ref = $scope.schooladmins;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    return $scope.selectAll = function(filter) {
      var i, len, ref, results, schooladmin;
      if (filter == null) {
        filter = '';
      }
      ref = $scope.schooladmins;
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        schooladmin = ref[i];
        if (filter === void 0 || filter === '') {
          schooladmin.selected = $scope.all_selected;
        }
        if (schooladmin.sn.toLowerCase().includes(filter.toLowerCase())) {
          schooladmin.selected = $scope.all_selected;
        }
        if (schooladmin.givenName.toLowerCase().includes(filter.toLowerCase())) {
          schooladmin.selected = $scope.all_selected;
        }
        if (schooladmin.sophomorixAdminClass.toLowerCase().includes(filter.toLowerCase())) {
          schooladmin.selected = $scope.all_selected;
        }
        if (schooladmin.sAMAccountName.toLowerCase().includes(filter.toLowerCase())) {
          results.push(schooladmin.selected = $scope.all_selected);
        } else {
          results.push(void 0);
        }
      }
      return results;
    };
  });

}).call(this);

// Generated by CoffeeScript 2.4.1
(function() {
  angular.module('lm.users').config(function($routeProvider) {
    return $routeProvider.when('/view/lm/users/globaladmins', {
      controller: 'LMUsersGloballadminsController',
      templateUrl: '/lmn_users:resources/partial/globaladmins.html'
    });
  });

  angular.module('lm.users').controller('LMUsersGloballadminsController', function($scope, $http, $location, $route, $uibModal, gettext, notify, messagebox, pageTitle, lmFileEditor, lmEncodingMap) {
    pageTitle.set(gettext('Globaladmins'));
    $scope.sorts = [
      {
        name: gettext('Login'),
        fx: function(x) {
          return x.sAMAccountName;
        }
      }
    ];
    $scope.sort = $scope.sorts[0];
    $scope.paging = {
      page: 1,
      pageSize: 50
    };
    $scope.all_selected = false;
    $http.post('/api/lm/sophomorixUsers/globaladmins', {
      action: 'get-all'
    }).then(function(resp) {
      return $scope.globaladmins = resp.data;
    });
    $scope.showInitialPassword = function(user) {
      var x;
      return $http.post('/api/lm/users/password', {
        users: (function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })(),
        action: 'get'
      }).then(function(resp) {
        return $http.get('/api/lm/users/test-first-password/' + user[0]['sAMAccountName']).then(function(response) {
          var msg;
          if (response.data === true) {
            msg = gettext('Initial password (still set)');
          } else {
            msg = gettext('Initial password (changed from user)');
          }
          return messagebox.show({
            title: msg,
            text: resp.data,
            positive: 'OK'
          });
        });
      });
    };
    $scope.setInitialPassword = function(user) {
      var x;
      return $http.post('/api/lm/users/password', {
        users: (function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })(),
        action: 'set-initial'
      }).then(function(resp) {
        return notify.success(gettext('Initial password set'));
      });
    };
    $scope.setRandomPassword = function(user) {
      var x;
      return $http.post('/api/lm/users/password', {
        users: (function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })(),
        action: 'set-random'
      }).then(function(resp) {
        return notify.success(gettext('Random password set'));
      });
    };
    $scope.setCustomPassword = function(user, type) {
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/customPassword.modal.html',
        controller: 'LMNUsersCustomPasswordController',
        size: 'mg',
        resolve: {
          users: function() {
            return user;
          },
          type: function() {
            return type;
          }
        }
      });
    };
    $scope.deleteGlobalAdmin = function(user) {
      var x;
      return messagebox.show({
        title: gettext('Delete User'),
        text: gettext("Delete global-administrator " + ((function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })()) + '?'),
        positive: 'Delete',
        negative: 'Cancel'
      }).then(function() {
        return $http.post('/api/lm/users/change-global-admin', {
          users: (function() {
            var i, len, results;
            results = [];
            for (i = 0, len = user.length; i < len; i++) {
              x = user[i];
              results.push(x['sAMAccountName']);
            }
            return results;
          })(),
          action: 'delete'
        }).then(function(resp) {
          $route.reload();
          return notify.success(gettext('User deleted'));
        });
      });
    };
    $scope.addGlobalAdmin = function() {
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/addAdmin.modal.html',
        controller: 'LMNUsersAddAdminController',
        size: 'mg',
        resolve: {
          role: function() {
            return angular.copy('global-admin');
          }
        }
      });
    };
    $scope.userInfo = function(user) {
      console.log(user);
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/userDetails.modal.html',
        controller: 'LMNUserDetailsController',
        size: 'lg',
        resolve: {
          id: function() {
            return user[0]['sAMAccountName'];
          },
          role: function() {
            return 'globaladmins';
          }
        }
      });
    };
    $scope.haveSelection = function() {
      var i, len, ref, x;
      if ($scope.globaladmins) {
        ref = $scope.globaladmins;
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            return true;
          }
        }
      }
      return false;
    };
    $scope.batchSetInitialPassword = function() {
      var x;
      return $scope.setInitialPassword((function() {
        var i, len, ref, results;
        ref = $scope.globaladmins;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.batchSetRandomPassword = function() {
      var x;
      return $scope.setRandomPassword((function() {
        var i, len, ref, results;
        ref = $scope.globaladmins;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.batchSetCustomPassword = function() {
      var x;
      return $scope.setCustomPassword((function() {
        var i, len, ref, results;
        ref = $scope.globaladmins;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    return $scope.selectAll = function(filter) {
      var globaladmin, i, len, ref, results;
      if (filter == null) {
        filter = '';
      }
      ref = $scope.globaladmins;
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        globaladmin = ref[i];
        if (filter === void 0 || filter === '') {
          globaladmin.selected = $scope.all_selected;
        }
        if (globaladmin.sn.toLowerCase().includes(filter.toLowerCase())) {
          globaladmin.selected = $scope.all_selected;
        }
        if (globaladmin.givenName.toLowerCase().includes(filter.toLowerCase())) {
          globaladmin.selected = $scope.all_selected;
        }
        if (globaladmin.sophomorixAdminClass.toLowerCase().includes(filter.toLowerCase())) {
          globaladmin.selected = $scope.all_selected;
        }
        if (globaladmin.sAMAccountName.toLowerCase().includes(filter.toLowerCase())) {
          results.push(globaladmin.selected = $scope.all_selected);
        } else {
          results.push(void 0);
        }
      }
      return results;
    };
  });

}).call(this);

// Generated by CoffeeScript 2.4.1
(function() {
  angular.module('lm.users').config(function($routeProvider) {
    return $routeProvider.when('/view/lm/users/extra-students', {
      controller: 'LMUsersExtraStudentsController',
      templateUrl: '/lmn_users:resources/partial/extra-students.html'
    });
  });

  angular.module('lm.users').controller('LMUsersExtraStudentsController', function($scope, $http, $uibModal, $route, gettext, notify, pageTitle, lmEncodingMap, lmFileEditor, lmFileBackups, validation) {
    pageTitle.set(gettext('Extra Students'));
    $scope.sorts = [
      {
        name: gettext('Class'),
        fx: function(x) {
          return x.class;
        }
      },
      {
        name: gettext('First name'),
        fx: function(x) {
          return x.first_name;
        }
      },
      {
        name: gettext('Last name'),
        fx: function(x) {
          return x.last_name;
        }
      },
      {
        name: gettext('Birthday'),
        fx: function(x) {
          return x.birthday;
        }
      },
      {
        name: gettext('Login'),
        fx: function(x) {
          return x.login;
        }
      }
    ];
    $scope.sort = $scope.sorts[0];
    $scope.paging = {
      page: 1,
      pageSize: 100
    };
    $scope.first_save = false;
    $scope.validateField = function(name, val, isnew, filter = null) {
      var valid;
      // TODO : what valid chars for class, name and course ?
      // Temporary solution : not filter these fields
      if (name === 'TODO') {
        return "";
      }
      // TODO : is pasword necessary for extra course ? Filtered only if not undefined.
      // Desired passwords will be marked if not strong enough, is it necessary for extra courses ?
      if (name === 'Password' && !val) {
        return "";
      }
      valid = validation["isValid" + name](val) && val;
      if (filter === 'students') {
        valid = valid && ($scope.students.filter(validation.findval('login', val)).length < 2);
      }
      if (valid) {
        return "";
      }
      if (isnew && !$scope.first_save) {
        return "has-error-new";
      } else {
        return "has-error";
      }
    };
    $http.get('/api/lm/schoolsettings').then(function(resp) {
      $scope.encoding = lmEncodingMap[resp.data.encoding_students_extra] || 'ISO8859-1';
      return $http.get(`/api/lm/users/extra-students?encoding=${$scope.encoding}`).then(function(resp) {
        return $scope.students = resp.data;
      });
    });
    $scope.add = function() {
      if ($scope.students.length > 0) {
        $scope.paging.page = Math.floor(($scope.students.length - 1) / $scope.paging.pageSize) + 1;
      }
      return $scope.students.push({
        _isNew: true
      });
    };
    $scope.remove = function(student) {
      return $scope.students.remove(student);
    };
    $scope.editCSV = function() {
      return lmFileEditor.show('/etc/linuxmuster/sophomorix/default-school/extrastudents.csv', $scope.encoding).then(function() {
        return $route.reload();
      });
    };
    $scope.numErrors = function() {
      return document.getElementsByClassName("has-error").length + document.getElementsByClassName("has-error-new").length > 0;
    };
    $scope.save = function() {
      if ($scope.numErrors()) {
        $scope.first_save = true;
        angular.element(document.getElementsByClassName("has-error-new")).addClass('has-error');
        notify.error('Required data missing');
        return;
      }
      return $http.post(`/api/lm/users/extra-students?encoding=${$scope.encoding}`, $scope.students).then(function() {
        return notify.success('Saved');
      });
    };
    $scope.saveAndCheck = function() {
      return $scope.save().then(function() {
        return $uibModal.open({
          templateUrl: '/lmn_users:resources/partial/check.modal.html',
          controller: 'LMUsersCheckModalController',
          backdrop: 'static'
        });
      });
    };
    return $scope.backups = function() {
      return lmFileBackups.show('/etc/linuxmuster/sophomorix/default-school/extrastudents.csv', $scope.encoding);
    };
  });

}).call(this);

// Generated by CoffeeScript 2.4.1
(function() {
  angular.module('lm.users').config(function($routeProvider) {
    return $routeProvider.when('/view/lm/users/extra-courses', {
      controller: 'LMUsersExtraCoursesController',
      templateUrl: '/lmn_users:resources/partial/extra-courses.html'
    });
  });

  angular.module('lm.users').controller('LMUsersExtraCoursesController', function($scope, $http, $uibModal, $route, notify, gettext, pageTitle, lmEncodingMap, lmFileEditor, lmFileBackups, validation) {
    pageTitle.set(gettext('Extra Courses'));
    $scope.sorts = [
      {
        name: gettext('Course'),
        fx: function(x) {
          return x.course;
        }
      },
      {
        name: gettext('Base name'),
        fx: function(x) {
          return x.base_name;
        }
      },
      {
        name: gettext('Birthday'),
        fx: function(x) {
          return x.birthday;
        }
      },
      {
        name: gettext('Count'),
        fx: function(x) {
          return x.count;
        }
      },
      {
        name: gettext('GECOS'),
        fx: function(x) {
          return x.gecos;
        }
      }
    ];
    $scope.sort = $scope.sorts[0];
    $scope.paging = {
      page: 1,
      pageSize: 100
    };
    $http.get('/api/lm/schoolsettings').then(function(resp) {
      $scope.encoding = lmEncodingMap[resp.data.encoding_courses_extra] || 'ISO8859-1';
      return $http.get(`/api/lm/users/extra-courses?encoding=${$scope.encoding}`).then(function(resp) {
        return $scope.courses = resp.data;
      });
    });
    $scope.first_save = false;
    $scope.validateField = function(name, val, isnew, filter = null) {
      var valid;
      // TODO : what valid chars for class, name and course ?
      // Temporary solution : not filter these fields
      if (name === 'TODO') {
        return "";
      }
      // TODO : is pasword necessary for extra course ? Filtered only if not undefined.
      // Desired passwords will be marked if not strong enough, is it necessary for extra courses ?
      if (name === 'Password' && !val) {
        return "";
      }
      valid = validation["isValid" + name](val) && val;
      if (valid) {
        return "";
      }
      if (isnew && !$scope.first_save) {
        return "has-error-new";
      } else {
        return "has-error";
      }
    };
    $scope.add = function() {
      if ($scope.courses.length > 0) {
        $scope.paging.page = Math.floor(($scope.courses.length - 1) / $scope.paging.pageSize) + 1;
      }
      return $scope.courses.push({
        _isNew: true
      });
    };
    $scope.remove = function(course) {
      return $scope.courses.remove(course);
    };
    $scope.editCSV = function() {
      return lmFileEditor.show('/etc/linuxmuster/sophomorix/default-school/extraclasses.csv', $scope.encoding).then(function() {
        return $route.reload();
      });
    };
    $scope.numErrors = function() {
      return document.getElementsByClassName("has-error").length + document.getElementsByClassName("has-error-new").length > 0;
    };
    $scope.save = function() {
      if ($scope.numErrors()) {
        $scope.first_save = true;
        angular.element(document.getElementsByClassName("has-error-new")).addClass('has-error');
        notify.error('Required data missing');
        return;
      }
      return $http.post(`/api/lm/users/extra-courses?encoding=${$scope.encoding}`, $scope.courses).then(function() {
        return notify.success(gettext('Saved'));
      });
    };
    $scope.saveAndCheck = function() {
      return $scope.save().then(function() {
        return $uibModal.open({
          templateUrl: '/lmn_users:resources/partial/check.modal.html',
          controller: 'LMUsersCheckModalController',
          backdrop: 'static'
        });
      });
    };
    return $scope.backups = function() {
      return lmFileBackups.show('/etc/linuxmuster/sophomorix/default-school/extraclasses.csv', $scope.encoding);
    };
  });

}).call(this);

// Generated by CoffeeScript 2.4.1
(function() {
  angular.module('lm.users').config(function($routeProvider) {
    return $routeProvider.when('/view/lm/users/teachers', {
      controller: 'LMUsersTeachersController',
      templateUrl: '/lmn_users:resources/partial/teachers.html'
    });
  });

  angular.module('lm.users').controller('LMUsersTeachersController', function($scope, $http, $location, $route, $uibModal, gettext, notify, messagebox, pageTitle, lmFileEditor, lmEncodingMap) {
    pageTitle.set(gettext('Teachers'));
    $scope.sorts = [
      {
        name: gettext('First name'),
        fx: function(x) {
          return x.givenName;
        }
      },
      {
        name: gettext('Last name'),
        fx: function(x) {
          return x.sn;
        }
      },
      {
        name: gettext('Login'),
        fx: function(x) {
          return x.sAMAccountName;
        }
      },
      {
        name: gettext('Birthday'),
        fx: function(x) {
          return x.sophomorixBirthdate;
        }
      },
      {
        name: gettext('Status'),
        fx: function(x) {
          return x.sophomorixStatus.tag;
        }
      }
    ];
    $scope.sort = $scope.sorts[0];
    $scope.paging = {
      page: 1,
      pageSize: 50
    };
    $scope.all_selected = false;
    $scope.query = '';
    $http.post('/api/lm/sophomorixUsers/teachers', {
      action: 'get-all'
    }).then(function(resp) {
      $scope.teachers = resp.data;
      return console.log(resp.data);
    });
    $scope.showInitialPassword = function(users) {
      var type, user;
      user = [];
      user[0] = users[0]["sAMAccountName"];
      // function needs an array which contains user on first position
      type = gettext('Initial password');
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/showPassword.modal.html',
        controller: 'LMNUsersShowPasswordController',
        resolve: {
          user: function() {
            return user;
          },
          type: function() {
            return type;
          }
        }
      });
    };
    $scope.teachersQuota = false;
    $scope.getQuotas = function() {
      var t, teacherList;
      teacherList = (function() {
        var i, len, ref, results;
        ref = $scope.teachers;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          t = ref[i];
          results.push(t.sAMAccountName);
        }
        return results;
      })();
      return $http.post('/api/lm/users/get-group-quota', {
        groupList: teacherList
      }).then(function(resp) {
        $scope.teachersQuota = resp.data;
        return console.log($scope.teachersQuota);
      });
    };
    $scope.setInitialPassword = function(user) {
      var x;
      return $http.post('/api/lm/users/password', {
        users: (function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })(),
        action: 'set-initial'
      }).then(function(resp) {
        return notify.success(gettext('Initial password set'));
      });
    };
    $scope.setRandomPassword = function(user) {
      var x;
      return $http.post('/api/lm/users/password', {
        users: (function() {
          var i, len, results;
          results = [];
          for (i = 0, len = user.length; i < len; i++) {
            x = user[i];
            results.push(x['sAMAccountName']);
          }
          return results;
        })(),
        action: 'set-random'
      }).then(function(resp) {
        return notify.success(gettext('Random password set'));
      });
    };
    $scope.setCustomPassword = function(user, type) {
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/customPassword.modal.html',
        controller: 'LMNUsersCustomPasswordController',
        size: 'mg',
        resolve: {
          users: function() {
            return user;
          },
          type: function() {
            return type;
          }
        }
      });
    };
    $scope.userInfo = function(user) {
      console.log(user);
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/userDetails.modal.html',
        controller: 'LMNUserDetailsController',
        size: 'lg',
        resolve: {
          id: function() {
            return user[0]['sAMAccountName'];
          },
          role: function() {
            return 'teachers';
          }
        }
      });
    };
    $scope.haveSelection = function() {
      var i, len, ref, x;
      if ($scope.teachers) {
        ref = $scope.teachers;
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            return true;
          }
        }
      }
      return false;
    };
    $scope.batchSetInitialPassword = function() {
      var x;
      return $scope.setInitialPassword((function() {
        var i, len, ref, results;
        ref = $scope.teachers;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.batchSetRandomPassword = function() {
      var x;
      return $scope.setRandomPassword((function() {
        var i, len, ref, results;
        ref = $scope.teachers;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.batchSetCustomPassword = function() {
      var x;
      return $scope.setCustomPassword((function() {
        var i, len, ref, results;
        ref = $scope.teachers;
        results = [];
        for (i = 0, len = ref.length; i < len; i++) {
          x = ref[i];
          if (x.selected) {
            results.push(x);
          }
        }
        return results;
      })());
    };
    $scope.filter = function(row) {
      var i, len, ref, result, value;
      // Only query sAMAccountName, givenName and sn
      result = false;
      ref = ['sAMAccountName', 'givenName', 'sn'];
      for (i = 0, len = ref.length; i < len; i++) {
        value = ref[i];
        result = result || row[value].toLowerCase().indexOf($scope.query.toLowerCase() || '') !== -1;
      }
      return result;
    };
    return $scope.selectAll = function(query) {
      var i, len, ref, results, teacher;
      if (query == null) {
        query = '';
      }
      ref = $scope.teachers;
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        teacher = ref[i];
        if (query === void 0 || query === '') {
          teacher.selected = $scope.all_selected;
        }
        if (teacher.sn.toLowerCase().includes(query.toLowerCase())) {
          teacher.selected = $scope.all_selected;
        }
        if (teacher.givenName.toLowerCase().includes(query.toLowerCase())) {
          teacher.selected = $scope.all_selected;
        }
        if (teacher.sophomorixAdminClass.toLowerCase().includes(query.toLowerCase())) {
          teacher.selected = $scope.all_selected;
        }
        if (teacher.sAMAccountName.toLowerCase().includes(query.toLowerCase())) {
          results.push(teacher.selected = $scope.all_selected);
        } else {
          results.push(void 0);
        }
      }
      return results;
    };
  });

}).call(this);

// Generated by CoffeeScript 2.4.1
(function() {
  angular.module('lm.users').config(function($routeProvider) {
    return $routeProvider.when('/view/lm/users/print-passwords', {
      controller: 'LMUsersPrintPasswordsController',
      templateUrl: '/lmn_users:resources/partial/print-passwords.html'
    });
  });

  angular.module('lm.users').controller('LMUsersPrintPasswordsOptionsModalController', function($scope, $uibModalInstance, $http, notify, messagebox, gettext, schoolclass, classes, user) {
    $scope.options = {
      format: 'pdf',
      one_per_page: false,
      pdflatex: false,
      schoolclass: schoolclass,
      user: user
    };
    if ($scope.options.user === 'root') {
      $scope.options.user = 'global-admin';
    }
    $scope.title = schoolclass !== '' ? gettext("Class") + `: ${schoolclass}` : gettext('All users');
    $scope.print = function() {
      var msg;
      msg = messagebox.show({
        progress: true
      });
      return $http.post('/api/lm/users/print', $scope.options).then(function(resp) {
        if (resp.data === 'success') {
          notify.success(gettext("Created password pdf"));
          location.href = `/api/lm/users/print-download/${(schoolclass !== '' ? schoolclass : 'add')}-${$scope.options.user}.${($scope.options.format === 'pdf' ? 'pdf' : 'csv')}`;
        } else {
          notify.error(gettext("Could not create password pdf"));
        }
        return $uibModalInstance.close();
      }).finally(function() {
        return msg.close();
      });
    };
    return $scope.cancel = function() {
      return $uibModalInstance.dismiss();
    };
  });

  angular.module('lm.users').controller('LMUsersPrintPasswordsController', function($scope, $http, $location, $route, $uibModal, gettext, notify, messagebox, pageTitle, lmFileEditor) {
    pageTitle.set(gettext('Print Passwords'));
    $scope.select = function(schoolclass, user) {
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/print-passwords.options.modal.html',
        controller: 'LMUsersPrintPasswordsOptionsModalController',
        resolve: {
          schoolclass: function() {
            return schoolclass;
          },
          classes: function() {
            return $scope.classes;
          },
          user: function() {
            return user;
          }
        }
      });
    };
    $scope.filterGroupType = function(val) {
      return function(dict) {
        return dict['type'] === val;
      };
    };
    $scope.filterGroupMembership = function(val) {
      return function(dict) {
        return dict['membership'] === val;
      };
    };
    $scope.getGroups = function(username) {
      if ($scope.identity.user === 'root' || $scope.identity.profile.sophomorixAdminClass === 'global-admins' || $scope.identity.profile.sophomorixAdminClass === 'school-admins') {
        return $http.get('/api/lm/users/print').then(function(resp) {
          return $scope.classes = resp.data;
        });
      } else {
        return $http.post('/api/lmn/groupmembership', {
          action: 'list-groups',
          username: username,
          profil: $scope.identity.profile
        }).then(function(resp) {
          var i, item, len, ref, results;
          $scope.groups = resp.data[0];
          $scope.userclasses = $scope.groups.filter($scope.filterGroupType('schoolclass'));
          $scope.userclasses = $scope.userclasses.filter($scope.filterGroupMembership(true));
          $scope.classes = [];
          ref = $scope.userclasses;
          results = [];
          for (i = 0, len = ref.length; i < len; i++) {
            item = ref[i];
            results.push($scope.classes.push(item.groupname));
          }
          return results;
        });
      }
    };
    return $scope.$watch('identity.user', function() {
      if ($scope.identity.user === void 0) {
        return;
      }
      if ($scope.identity.user === null) {
        return;
      }
      if ($scope.identity.user === 'root') {
        return;
      }
      $scope.getGroups($scope.identity.user);
    });
  });

}).call(this);

// Generated by CoffeeScript 2.4.1
(function() {
  angular.module('lm.users').controller('LMUsersCheckResultsModalController', function($scope, $uibModalInstance, $uibModal, data, gettext) {
    $scope.data = data;
    $scope._ = {
      doAdd: data['SUMMARY'][1]['ADD']['RESULT'] > 0,
      doMove: data['SUMMARY'][2]['UPDATE']['RESULT'] > 0,
      doKill: data['SUMMARY'][3]['KILL']['RESULT'] > 0
    };
    $scope.tab_selected = "all";
    $scope.tab_selected_text = {
      "all": gettext('Apply'),
      "add": gettext('Add user(s)'),
      "move": gettext('Move user(s)'),
      "kill": gettext('Kill user(s)'),
      "error": gettext('Errors')
    };
    $scope.select = function(tab) {
      return $scope.tab_selected = tab;
    };
    //# Use same string status for, e.g., Removable and Killable ?
    $scope.user_status = {
      'U': 'Usable (U)',
      'A': 'Activated (A)',
      'E': 'Enabled (E)',
      'S': 'Self-activated (S)',
      'P': 'Permanent (P)',
      'T': 'Tolerated (T)',
      'L': 'Locked (L)',
      'D': 'Deactivated (D)',
      'F': 'Frozen (F)',
      'R': 'Removable (R)',
      'K': 'Killable (K)',
      'X': 'Exam (X)',
      'M': 'Managed (M)'
    };
    $scope.status_filter = function(status) {
      if ($scope.user_status[status] === void 0) {
        return status;
      } else {
        return $scope.user_status[status];
      }
    };
    $scope.apply = function(mode) {
      var msg;
      if (mode === "add") {
        $scope._ = {
          doAdd: true,
          doMove: false,
          doKill: false
        };
      }
      if (mode === "move") {
        $scope._ = {
          doAdd: false,
          doMove: true,
          doKill: false
        };
      }
      if (mode === "kill") {
        $scope._ = {
          doAdd: false,
          doMove: false,
          doKill: true
        };
      }
      $uibModalInstance.close();
      msg = $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/apply.modal.html',
        controller: 'LMUsersApplyModalController',
        backdrop: 'static',
        size: 'lg',
        resolve: {
          params: function() {
            return $scope._;
          }
        }
      });
      return $uibModalInstance.close();
    };
    return $scope.cancel = function() {
      return $uibModalInstance.dismiss();
    };
  });

  angular.module('lm.users').controller('LMUsersApplyModalController', function($scope, $uibModalInstance, $http, $route, gettext, notify, params) {
    $scope.options = {
      autoscroll: true
    };
    $scope.close = function() {
      return $uibModalInstance.close();
    };
    $scope.isWorking = true;
    return $http.post('/api/lm/users/apply', params).then(function(resp) {
      $scope.isWorking = false;
      notify.success(gettext('Changes applied'));
      return $route.reload();
    }).catch(function(resp) {
      $scope.isWorking = false;
      return notify.error(gettext('Failed'), resp.data.message);
    });
  });

  angular.module('lm.users').controller('LMUsersCheckModalController', function($scope, $http, notify, $uibModalInstance, $uibModal, gettext) {
    $scope.isWorking = true;
    $http.get('/api/lm/users/check').then(function(resp) {
      if (!resp.data) {
        notify.error(gettext('Unknown error!'), gettext('Please run sophomorix-check manually to identity the reason.'));
        $uibModalInstance.close();
        return;
      }
      if (resp.data['OUTPUT'][0]['TYPE'] === 'ERROR') {
        notify.error(gettext('Check failed'), resp.data.message);
        $scope.isWorking = false;
        $scope.error = true;
        return $scope.errorMessage = resp.data['OUTPUT'][0]['MESSAGE_EN'];
      } else {
        $scope.showCheckResults(resp.data);
        return $uibModalInstance.close();
      }
    }).catch(function(resp) {
      $scope.isWorking = false;
      $scope.error = true;
      return notify.error(gettext('Check failed'), resp.data.message);
    });
    $scope.showCheckResults = function(data) {
      $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/result.modal.html',
        controller: 'LMUsersCheckResultsModalController',
        resolve: {
          data: function() {
            return data;
          }
        }
      });
      return console.log(data);
    };
    return $scope.close = function() {
      return $uibModalInstance.close();
    };
  });

}).call(this);

// Generated by CoffeeScript 2.4.1
(function() {
  angular.module('lm.users').controller('LMNUsersShowPasswordController', function($scope, $uibModal, $uibModalInstance, $http, gettext, notify, messagebox, pageTitle, user, type) {
    $scope.username = user[0];
    $scope.type = type;
    $http.post('/api/lm/users/password', {
      users: user,
      action: 'get'
    }).then(function(resp) {
      var password;
      password = resp.data;
      $scope.password = password;
      return $http.get('/api/lm/users/test-first-password/' + user).then(function(response) {
        if (response.data === true) {
          return $scope.passwordStatus = gettext('Still Set');
        } else {
          return $scope.passwordStatus = gettext('Changed from user');
        }
      });
    });
    //messagebox.show(title: msg, text: resp.data, positive: 'OK')

    //$http.post('/api/lm/users/password', {users: user, action: 'get'}).then (resp) ->
    return $scope.close = function() {
      return $uibModalInstance.dismiss();
    };
  });

  angular.module('lm.users').controller('LMNUsersCustomPasswordController', function($scope, $uibModal, $uibModalInstance, $http, gettext, notify, messagebox, pageTitle, users, type, validation) {
    $scope.username = users;
    $scope.action = type;
    $scope.save = function(userpw) {
      var action, test, x;
      if (type == null) {
        action = 'set';
      } else {
        if (type === 'actual') {
          action = 'set-actual';
        } else {
          action = 'set';
        }
      }
      if (!$scope.userpw) {
        notify.error(gettext("You have to enter a password"));
        return;
      }
      test = validation.isValidPassword($scope.userpw);
      if (test !== true) {
        notify.error(gettext(test));
        return;
      } else {
        $http.post('/api/lm/users/password', {
          users: (function() {
            var j, len, results;
            results = [];
            for (j = 0, len = users.length; j < len; j++) {
              x = users[j];
              results.push(x['sAMAccountName']);
            }
            return results;
          })(),
          action: action,
          password: $scope.userpw,
          type: type
        }).then(function(resp) {
          return notify.success(gettext('New password set'));
        });
      }
      return $uibModalInstance.dismiss();
    };
    return $scope.close = function() {
      return $uibModalInstance.dismiss();
    };
  });

  angular.module('lm.users').controller('LMNUserDetailsController', function($scope, $route, $uibModal, $uibModalInstance, $http, gettext, notify, messagebox, pageTitle, id, role) {
    //notify.error gettext("You have to enter a username")
    $scope.id = id;
    $scope.showGroupDetails = true;
    $scope.showQuotaDetails = true;
    $scope.nevertext = gettext('Never');
    $scope.formatDate = function(date) {
      var day, hour, min, month, sec, year;
      if (date === "19700101000000.0Z") {
        return $scope.nevertext;
      } else if (date === void 0) {
        return "undefined";
      } else {
        // Sophomorix date format is yyyyMMddhhmmss.0Z
        year = date.slice(0, 4);
        month = +date.slice(4, 6) - 1; // Month start at 0
        day = date.slice(6, 8);
        hour = date.slice(8, 10);
        min = date.slice(10, 12);
        sec = date.slice(12, 14);
        return new Date(year, month, day, hour, min, sec);
      }
    };
    $scope.hidetext = gettext("Hide");
    $scope.showtext = gettext("Show");
    $http.post('/api/lm/sophomorixUsers/' + role, {
      action: 'get-specified',
      user: id
    }).then(function(resp) {
      var category, cn, dn, j, len, ref;
      $scope.userDetails = resp.data;
      $scope.groups = [];
      ref = $scope.userDetails[0]['memberOf'];
      for (j = 0, len = ref.length; j < len; j++) {
        dn = ref[j];
        cn = dn.split(',')[0].split('=')[1];
        category = dn.split(',')[1].split('=')[1];
        $scope.groups.push({
          'cn': cn,
          'category': category
        });
      }
      return console.log($scope.userDetails);
    });
    $http.get(`/api/lmn/quota/${id}`).then(function(resp) {
      var ref, results, share, total, type, usage, used, values;
      $scope.quotas = [];
      ref = resp.data['QUOTA_USAGE_BY_SHARE'];
      results = [];
      for (share in ref) {
        values = ref[share];
        // default-school and linuxmuster-global both needed ?
        // cloudquota and mailquota not in QUOTA_USAGE_BY_SHARE ?
        used = values['USED_MiB'];
        total = values['HARD_LIMIT_MiB'];
        if (typeof total === 'string') {
          if (total === 'NO LIMIT') {
            total = gettext('NO LIMIT');
          }
          results.push($scope.quotas.push({
            'share': share,
            'total': gettext(total),
            'used': used,
            'usage': 0,
            'type': "success"
          }));
        } else {
          usage = Math.floor((100 * used) / total);
          if (usage < 60) {
            type = "success";
          } else if (usage < 80) {
            type = "warning";
          } else {
            type = "danger";
          }
          results.push($scope.quotas.push({
            'share': share,
            'total': total + " MiB",
            'used': used,
            'usage': usage,
            'type': type
          }));
        }
      }
      return results;
    });
    return $scope.close = function() {
      return $uibModalInstance.dismiss();
    };
  });

  angular.module('lm.users').controller('LMUsersSortListModalController', function($scope, $window, $http, $uibModalInstance, messagebox, notify, $uibModal, gettext, filesystem, userlist, userListCSV) {
    $scope.userListCSV = userListCSV;
    $scope.userlist = userlist;
    $scope.rebuildCSV = function() {
      var element, i, j, len, ref, results;
      // add empty 'not used' fields if CSV contains more coloumns than fields
      while ($scope['userListCSV'].length > $scope['coloumnTitles'].length) {
        $scope['coloumnTitles'].push({
          name: gettext('not used')
        });
      }
      i = 0;
      ref = $scope.userListCSV;
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        element = ref[j];
        element.coloumn = $scope.coloumnTitles[i]['id'];
        results.push(i = i + 1);
      }
      return results;
    };
    //console.log ($scope['userListCSV'])
    $scope.togglecustomField = function(field) {
      var pos;
      // get index of field in coloumnTitles (-1 if not presend)
      pos = $scope.coloumnTitles.map(function(e) {
        return e.name;
      }).indexOf(field);
      // add field if not presend
      if (pos === -1) {
        $scope.coloumnTitles.splice(4, 0, {
          name: field,
          id: field
        });
      } else {
        // splice this field 
        $scope.coloumnTitles.splice(pos, 1);
      }
      return $scope.rebuildCSV();
    };
    $scope.accept = function() {
      //console.log ($scope.userListCSV)
      return $uibModalInstance.close($scope.userListCSV);
    };
    $scope.close = function() {
      return $uibModalInstance.dismiss();
    };
    if (userlist === 'students.csv') {
      $scope.coloumnTitles = [
        {
          name: gettext('class'),
          id: 'class'
        },
        {
          name: gettext('lastname'),
          id: 'lastname'
        },
        {
          name: gettext('firstname'),
          id: 'firstname'
        },
        {
          name: gettext('birthday'),
          id: 'birthday'
        }
      ];
    }
    if (userlist === 'teachers.csv') {
      $scope.coloumnTitles = [
        {
          name: gettext('lastname'),
          id: 'lastname'
        },
        {
          name: gettext('firstname'),
          id: 'firstname'
        },
        {
          name: gettext('birthday'),
          id: 'birthday'
        },
        {
          name: gettext('login'),
          id: 'login'
        }
      ];
    }
    return $scope.rebuildCSV();
  });

  angular.module('lm.users').controller('LMUsersUploadModalController', function($scope, $window, $http, $uibModalInstance, messagebox, notify, $uibModal, gettext, filesystem, userlist) {
    $scope.path = "/tmp/";
    $scope.onUploadBegin = function($flow) {
      var msg;
      $uibModalInstance.close();
      msg = messagebox.show({
        progress: true
      });
      return filesystem.startFlowUpload($flow, $scope.path).then(function() {
        var filename;
        notify.success(gettext('Uploaded'));
        filename = $flow["files"][0]["name"];
        return $http.post('/api/lmn/sophomorixUsers/import-list', {
          action: 'get',
          path: $scope.path + filename,
          userlist: userlist
        }).then(function(resp) {
          var userListCSV;
          userListCSV = resp.data;
          //console.log (userListCSV)
          // console.log (resp['data'])
          $uibModal.open({
            templateUrl: '/lmn_users:resources/partial/sortList.modal.html',
            controller: 'LMUsersSortListModalController',
            resolve: {
              userListCSV: function() {
                return userListCSV;
              },
              userlist: function() {
                return userlist;
              }
            }
          }).result.then(function(result) {
            //console.log (result)
            return $http.post("/api/lmn/sophomorixUsers/import-list", {
              action: 'save',
              data: result,
              userlist: userlist
            }).then(function(resp) {
              //console.log (resp['data'])
              if (resp['data'][0] === 'ERROR') {
                notify.error(resp['data'][1]);
              }
              if (resp['data'][0] === 'LOG') {
                notify.success(gettext(resp['data'][1]));
              }
              // TODO: it would be better to reload just the content frame. Currently I dont know how to set the route to reload it
              $window.location.reload();
              msg.close();
              return notify.success(gettext('Saved'));
            });
          });
          return msg.close();
        });
      }, null, function(progress) {
        return msg.messagebox.title = `Uploading: ${Math.floor(100 * progress)}%`;
      });
    };
    return $scope.close = function() {
      return $uibModalInstance.close();
    };
  });

  angular.module('lm.users').controller('LMNUsersAddAdminController', function($scope, $route, $uibModal, $uibModalInstance, $http, gettext, notify, messagebox, pageTitle, role) {
    $scope.role = role;
    $scope.save = function(username) {
      if (!$scope.username) {
        notify.error(gettext("You have to enter a username"));
      } else {
        notify.success(gettext('Adding administrator...'));
        $http.post('/api/lm/users/change-' + role, {
          action: 'create',
          users: username
        }).then(function(resp) {
          // console.log (resp.data)
          if (resp['data'][0] === 'ERROR') {
            notify.error(resp['data'][1]);
          }
          if (resp['data'][0] === 'LOG') {
            notify.success(gettext(resp['data'][1]));
          }
          return $route.reload();
        });
        return $uibModalInstance.dismiss();
      }
    };
    return $scope.close = function() {
      return $uibModalInstance.dismiss();
    };
  });

}).call(this);

// Generated by CoffeeScript 2.4.1
(function() {
  angular.module('lm.users').config(function($routeProvider) {
    return $routeProvider.when('/view/lm/users/listmanagement', {
      controller: 'LMUsersListManagementController',
      templateUrl: '/lmn_users:resources/partial/listmanagement.html'
    });
  });

  angular.module('lm.users').controller('LMUsersListManagementController', function($scope, $http, $location, $route, $uibModal, gettext, notify, lmEncodingMap, messagebox, pageTitle, lmFileEditor, lmFileBackups, filesystem, validation) {
    pageTitle.set(gettext('Listmanagement'));
    $scope.students_sorts = [
      {
        name: gettext('Class'),
        fx: function(x) {
          return x.class;
        }
      },
      {
        name: gettext('First name'),
        fx: function(x) {
          return x.first_name;
        }
      },
      {
        name: gettext('Last name'),
        fx: function(x) {
          return x.last_name;
        }
      },
      {
        name: gettext('Birthday'),
        fx: function(x) {
          return x.birthday;
        }
      },
      {
        name: gettext('Student ID'),
        fx: function(x) {
          return x.id;
        }
      }
    ];
    $scope.teachers_sorts = [
      {
        name: gettext('Login'),
        fx: function(x) {
          return x.login;
        }
      },
      {
        name: gettext('First name'),
        fx: function(x) {
          return x.first_name;
        }
      },
      {
        name: gettext('Last name'),
        fx: function(x) {
          return x.last_name;
        }
      },
      {
        name: gettext('Login'),
        fx: function(x) {
          return x.login;
        }
      }
    ];
    $scope.extrastudents_sorts = [
      {
        name: gettext('Class'),
        fx: function(x) {
          return x.class;
        }
      },
      {
        name: gettext('First name'),
        fx: function(x) {
          return x.first_name;
        }
      },
      {
        name: gettext('Last name'),
        fx: function(x) {
          return x.last_name;
        }
      },
      {
        name: gettext('Birthday'),
        fx: function(x) {
          return x.birthday;
        }
      },
      {
        name: gettext('Login'),
        fx: function(x) {
          return x.login;
        }
      }
    ];
    $scope.courses_sorts = [
      {
        name: gettext('Course'),
        fx: function(x) {
          return x.course;
        }
      },
      {
        name: gettext('Base name'),
        fx: function(x) {
          return x.base_name;
        }
      },
      {
        name: gettext('Birthday'),
        fx: function(x) {
          return x.birthday;
        }
      },
      {
        name: gettext('Count'),
        fx: function(x) {
          return x.count;
        }
      },
      {
        name: gettext('GECOS'),
        fx: function(x) {
          return x.gecos;
        }
      }
    ];
    $scope.students_sort = $scope.students_sorts[0];
    $scope.teachers_sort = $scope.teachers_sorts[0];
    $scope.extrastudents_sort = $scope.students_sorts[0];
    $scope.courses_sort = $scope.teachers_sorts[0];
    $scope.paging = {
      page_students: 1,
      page_teachers: 1,
      page_extrastudents: 1,
      page_courses: 1,
      pageSize: 50
    };
    $scope.students_fields = {
      class: {
        visible: true,
        name: gettext('Class')
      },
      last_name: {
        visible: true,
        name: gettext('Last Name')
      },
      first_name: {
        visible: true,
        name: gettext('First Name')
      },
      birthday: {
        visible: true,
        name: gettext('Birthday')
      },
      id: {
        visible: false,
        name: gettext('Student ID')
      }
    };
    $scope.teachers_fields = {
      last_name: {
        visible: true,
        name: gettext('Last Name')
      },
      first_name: {
        visible: true,
        name: gettext('First Name')
      },
      birthday: {
        visible: true,
        name: gettext('Birthday')
      },
      password: {
        visible: false,
        name: gettext('Desired Password')
      },
      login: {
        visible: true,
        name: gettext('Login')
      }
    };
    $scope.extrastudents_fields = {
      class: {
        visible: true,
        name: gettext('Class')
      },
      last_name: {
        visible: true,
        name: gettext('Last Name')
      },
      first_name: {
        visible: true,
        name: gettext('First Name')
      },
      birthday: {
        visible: true,
        name: gettext('Birthday')
      },
      login: {
        visible: true,
        name: gettext('Login')
      }
    };
    $scope.teachers_first_save = false;
    $scope.students_first_save = false;
    $scope.extrastudents_first_save = false;
    $scope.courses_first_save = false;
    $scope.teachers = '';
    $scope.students = '';
    $scope.extrastudents = '';
    $scope.courses = '';
    $scope.students_add = function() {
      if ($scope.students.length > 0) {
        $scope.paging.page_students = Math.floor(($scope.students.length - 1) / $scope.paging.pageSize) + 1;
      }
      $scope.students_filter = '';
      return $scope.students.push({
        '_isNew': true,
        'first_name': '',
        'last_name': '',
        'class': ''
      });
    };
    $scope.teachers_add = function() {
      if ($scope.teachers.length > 0) {
        $scope.paging.page_teachers = Math.floor(($scope.teachers.length - 1) / $scope.paging.pageSize) + 1;
      }
      $scope.teachers_filter = '';
      return $scope.teachers.push({
        class: 'Lehrer',
        _isNew: true
      });
    };
    $scope.extrastudents_add = function() {
      if ($scope.extrastudents.length > 0) {
        $scope.paging.page_extrastudents = Math.floor(($scope.extrastudents.length - 1) / $scope.paging.pageSize) + 1;
      }
      $scope.extrastudents_filter = '';
      return $scope.extrastudents.push({
        _isNew: true
      });
    };
    $scope.courses_add = function() {
      if ($scope.courses.length > 0) {
        $scope.paging.page_courses = Math.floor(($scope.courses.length - 1) / $scope.paging.pageSize) + 1;
      }
      $scope.courses_filter = '';
      return $scope.courses.push({
        _isNew: true
      });
    };
    $scope.students_remove = function(student) {
      return $scope.students.remove(student);
    };
    $scope.teachers_remove = function(teacher) {
      return $scope.teachers.remove(teacher);
    };
    $scope.extrastudents_remove = function(student) {
      return $scope.extrastudents.remove(student);
    };
    $scope.courses_remove = function(course) {
      return $scope.courses.remove(course);
    };
    $scope.getstudents = function() {
      if (!$scope.students) {
        return $http.get('/api/lm/schoolsettings').then(function(resp) {
          var school;
          school = 'default-school';
          $scope.students_encoding = resp.data["userfile.students.csv"].encoding;
          if ($scope.students_encoding === 'auto') {
            $http.post('/api/lmn/schoolsettings/determine-encoding', {
              path: '/etc/linuxmuster/sophomorix/' + school + '/students.csv'
            }).then(function(response) {
              if (response.data === 'unknown') {
                return $scope.students_encoding = 'utf-8';
              } else {
                return $scope.students_encoding = response.data;
              }
            });
          }
          return $http.get(`/api/lm/users/students-list?encoding=${$scope.students_encoding}`).then(function(resp) {
            return $scope.students = resp.data;
          });
        });
      }
    };
    $scope.getteachers = function() {
      if (!$scope.teachers) {
        return $http.get('/api/lm/schoolsettings').then(function(resp) {
          var school;
          school = 'default-school';
          $scope.teachers_encoding = resp.data["userfile.teachers.csv"].encoding;
          if ($scope.teachers_encoding === 'auto') {
            $http.post('/api/lmn/schoolsettings/determine-encoding', {
              path: '/etc/linuxmuster/sophomorix/' + school + '/teachers.csv'
            }).then(function(response) {
              if (response.data === 'unknown') {
                return $scope.teachers_encoding = 'utf-8';
              } else {
                return $scope.teachers_encoding = response.data;
              }
            });
          }
          return $http.get(`/api/lm/users/teachers-list?encoding=${$scope.students_encoding}`).then(function(resp) {
            return $scope.teachers = resp.data;
          });
        });
      }
    };
    $scope.getextrastudents = function() {
      if (!$scope.extrastudents) {
        return $http.get('/api/lm/schoolsettings').then(function(resp) {
          var school;
          school = 'default-school';
          $scope.extrastudents_encoding = resp.data["userfile.extrastudents.csv"].encoding;
          if ($scope.extrastudents_encoding === 'auto') {
            $http.post('/api/lmn/schoolsettings/determine-encoding', {
              path: '/etc/linuxmuster/sophomorix/' + school + '/extrastudents.csv'
            }).then(function(response) {
              if (response.data === 'unknown') {
                return $scope.extrastudents_encoding = 'utf-8';
              } else {
                return $scope.extrastudents_encoding = response.data;
              }
            });
          }
          return $http.get(`/api/lm/users/extra-students?encoding=${$scope.extrastudents_encoding}`).then(function(resp) {
            return $scope.extrastudents = resp.data;
          });
        });
      }
    };
    $scope.getcourses = function() {
      if (!$scope.courses) {
        return $http.get('/api/lm/schoolsettings').then(function(resp) {
          $scope.courses_encoding = lmEncodingMap[resp.data.encoding_courses_extra] || 'ISO8859-1';
          return $http.get(`/api/lm/users/extra-courses?encoding=${$scope.courses_encoding}`).then(function(resp) {
            return $scope.courses = resp.data;
          });
        });
      }
    };
    $scope.students_editCSV = function() {
      return lmFileEditor.show('/etc/linuxmuster/sophomorix/default-school/students.csv', $scope.students_encoding).then(function() {
        return $route.reload();
      });
    };
    $scope.teachers_editCSV = function() {
      return lmFileEditor.show('/etc/linuxmuster/sophomorix/default-school/teachers.csv', $scope.students_encoding).then(function() {
        return $route.reload();
      });
    };
    $scope.extrastudents_editCSV = function() {
      return lmFileEditor.show('/etc/linuxmuster/sophomorix/default-school/extrastudents.csv', $scope.extrastudents_encoding).then(function() {
        return $route.reload();
      });
    };
    $scope.courses_editCSV = function() {
      return lmFileEditor.show('/etc/linuxmuster/sophomorix/default-school/extraclasses.csv', $scope.courses_encoding).then(function() {
        return $route.reload();
      });
    };
    $scope.students_save = function() {
      if ($scope.numErrors()) {
        $scope.students_first_save = true;
        $scope.show_errors = true;
        angular.element(document.getElementsByClassName("has-error-new")).addClass('has-error');
        notify.error(gettext('Please check the errors.'));
        return;
      }
      $scope.show_errors = false;
      $scope.students_first_save = false;
      return $http.post(`/api/lm/users/students-list?encoding=${$scope.students_encoding}`, $scope.students).then(function() {
        return notify.success(gettext('Saved'));
      });
    };
    $scope.teachers_save = function() {
      if ($scope.numErrors()) {
        $scope.teachers_first_save = true;
        $scope.show_errors = true;
        angular.element(document.getElementsByClassName("has-error-new")).addClass('has-error');
        notify.error(gettext('Please check the errors.'));
        return;
      }
      $scope.show_errors = false;
      $scope.teachers_first_save = false;
      return $http.post(`/api/lm/users/teachers-list?encoding=${$scope.teachers_encoding}`, $scope.teachers).then(function() {
        return notify.success(gettext('Saved'));
      });
    };
    $scope.extrastudents_save = function() {
      if ($scope.numErrors()) {
        $scope.extrastudents_first_save = true;
        $scope.show_errors = true;
        angular.element(document.getElementsByClassName("has-error-new")).addClass('has-error');
        notify.error(gettext('Please check the errors.'));
        return;
      }
      $scope.show_errors = false;
      $scope.extrastudents_first_save = false;
      return $http.post(`/api/lm/users/extra-students?encoding=${$scope.extrastudents_encoding}`, $scope.extrastudents).then(function() {
        return notify.success('Saved');
      });
    };
    $scope.courses_save = function() {
      if ($scope.numErrors()) {
        $scope.courses_first_save = true;
        $scope.show_errors = true;
        angular.element(document.getElementsByClassName("has-error-new")).addClass('has-error');
        notify.error(gettext('Please check the errors.'));
        return;
      }
      $scope.show_errors = false;
      $scope.courses_first_save = false;
      return $http.post(`/api/lm/users/extra-courses?encoding=${$scope.courses_encoding}`, $scope.courses).then(function() {
        return notify.success(gettext('Saved'));
      });
    };
    $scope.students_confirmUpload = function() {
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/upload.modal.html',
        controller: 'LMUsersUploadModalController',
        backdrop: 'static',
        resolve: {
          userlist: function() {
            return 'students.csv';
          }
        }
      });
    };
    $scope.teachers_confirmUpload = function() {
      return $uibModal.open({
        templateUrl: '/lmn_users:resources/partial/upload.modal.html',
        controller: 'LMUsersUploadModalController',
        backdrop: 'static',
        resolve: {
          userlist: function() {
            return 'teachers.csv';
          }
        }
      });
    };
    $scope.students_backups = function() {
      return lmFileBackups.show('/etc/linuxmuster/sophomorix/default-school/students.csv', $scope.students_encoding);
    };
    $scope.teachers_backups = function() {
      return lmFileBackups.show('/etc/linuxmuster/sophomorix/default-school/teachers.csv', $scope.teachers_encoding);
    };
    $scope.extrastudents_backups = function() {
      return lmFileBackups.show('/etc/linuxmuster/sophomorix/default-school/extrastudents.csv', $scope.extrastudents_encoding);
    };
    $scope.courses_backups = function() {
      return lmFileBackups.show('/etc/linuxmuster/sophomorix/default-school/extraclasses.csv', $scope.courses_encoding);
    };
    // general functions
    $scope.error_msg = {};
    $scope.show_errors = false;
    $scope.emptyCells = {};
    $scope.dictLen = function(d) {
      return Object.keys(d).length;
    };
    $scope.validateField = function(name, val, isnew, ev, tab, filter = null) {
      var errorClass, test;
      // TODO : what valid chars for class, name and course ?
      // Temporary solution : not filter these fields
      if ($scope[tab + "_first_save"]) {
        errorClass = "has-error-new has-error";
      } else {
        errorClass = "has-error-new";
      }
      ev = ($scope.paging["page_" + tab] - 1) * $scope.paging.pageSize + 1 + parseInt(ev, 10);
      if (name.startsWith('TODO')) {
        if (!val) {
          $scope.emptyCells[name + "-" + tab + "-" + ev] = 1;
          return errorClass;
        } else {
          delete $scope.emptyCells[name + "-" + tab + "-" + ev];
          return "";
        }
      }
      // TODO : is pasword necessary for extra course ? Filtered only if not undefined.
      // Desired passwords will be marked if not strong enough, is it necessary for extra courses ?
      if (name === 'Password' && !val) {
        return "";
      }
      test = validation["isValid" + name](val);
      // Ensure the login is not duplicated, but ignore empty login
      if (filter === 'teachers') {
        if (val !== '') {
          test = test && ($scope.teachers.filter(validation.findval('login', val)).length < 2);
        }
      } else if (filter === 'extrastudents') {
        test = test && ($scope.extrastudents.filter(validation.findval('login', val)).length < 2);
      }
      // Login for teachers may be empty
      if (name === 'Login' && filter === 'teachers' && test === true) {
        delete $scope.error_msg[name + "-" + tab + "-" + ev];
        delete $scope.emptyCells[name + "-" + tab + "-" + ev];
        return "";
      } else if (test === true && val) {
        delete $scope.error_msg[name + "-" + tab + "-" + ev];
        delete $scope.emptyCells[name + "-" + tab + "-" + ev];
        return "";
      } else if (!val) {
        delete $scope.error_msg[name + "-" + tab + "-" + ev];
        $scope.emptyCells[name + "-" + tab + "-" + ev] = 1;
      } else {
        delete $scope.emptyCells[name + "-" + tab + "-" + ev];
        if (Object.values($scope.error_msg).indexOf(gettext(tab) + ": " + test) === -1) {
          $scope.error_msg[name + "-" + tab + "-" + ev] = gettext(tab) + ": " + test;
        }
      }
      return errorClass;
    };
    $scope.numErrors = function() {
      angular.element(document.getElementsByClassName("has-error")).removeClass('has-error');
      return $scope.dictLen($scope.error_msg) + $scope.dictLen($scope.emptyCells) > 0;
    };
    $scope.saveAndCheck = function(name) {
      if ($scope.numErrors()) {
        $scope[name + "_first_save"] = true;
        $scope.show_errors = true;
        angular.element(document.getElementsByClassName("has-error-new")).addClass('has-error');
        notify.error(gettext('Please check the errors.'));
        return;
      }
      $scope.show_errors = false;
      return $scope[name + "_save"]().then(function() {
        return $uibModal.open({
          templateUrl: '/lmn_users:resources/partial/check.modal.html',
          controller: 'LMUsersCheckModalController',
          backdrop: 'static'
        });
      });
    };
    // Loading first tab
    return $scope.getstudents();
  });

}).call(this);

