-- MySQL dump 10.13  Distrib 5.5.57, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: coldformix
-- ------------------------------------------------------
-- Server version	5.5.57-0ubuntu0.14.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `oils`
--

DROP TABLE IF EXISTS `oils`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oils` (
  `name` varchar(255) NOT NULL DEFAULT '',
  `chemical_name_de` varchar(255) DEFAULT NULL,
  `fckw_hfckw` tinyint(4) DEFAULT NULL,
  `hfkw_mix` tinyint(4) DEFAULT NULL,
  `kw` tinyint(4) DEFAULT NULL,
  `nh3_r723` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oils`
--

LOCK TABLES `oils` WRITE;
/*!40000 ALTER TABLE `oils` DISABLE KEYS */;
INSERT INTO `oils` VALUES ('MO','Mineralöl',1,0,1,1);
INSERT INTO `oils` VALUES ('AB','Alkylbenzol',1,2,2,2);
INSERT INTO `oils` VALUES ('MO/AB','Mineralöl + Alkylbenzol',1,0,2,2);
INSERT INTO `oils` VALUES ('PAO','Poly-Alpha-Olefin',2,0,1,1);
INSERT INTO `oils` VALUES ('POE','Polyol-Ester',2,1,1,0);
INSERT INTO `oils` VALUES ('PVE','Polyvinyl-Ether-Öl',0,1,0,0);
INSERT INTO `oils` VALUES ('PAG','Poly-Alkylen-Glykol',0,2,2,2);
INSERT INTO `oils` VALUES ('HBM','Hydrobehandeltes Mineralöl',0,0,0,1);
/*!40000 ALTER TABLE `oils` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `refrigerants`
--

DROP TABLE IF EXISTS `refrigerants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `refrigerants` (
  `name` varchar(32) NOT NULL DEFAULT '',
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `chemical_name_de` varchar(255) NOT NULL DEFAULT '',
  `chemical_name_en` varchar(255) NOT NULL DEFAULT '',
  `chemical group` varchar(255) DEFAULT NULL,
  `oil_group` varchar(255) DEFAULT NULL,
  `filename` varchar(32) NOT NULL DEFAULT '',
  `latex` varchar(32) NOT NULL DEFAULT '',
  `structural_formula` varchar(255) NOT NULL DEFAULT '',
  `molecular_weight` float(6,2) NOT NULL DEFAULT '0.00',
  `comp_1` varchar(31) NOT NULL DEFAULT '',
  `comp_mpercent_1` float(3,1) NOT NULL DEFAULT '0.0',
  `comp_2` varchar(31) NOT NULL DEFAULT '',
  `comp_mpercent_2` float(3,1) NOT NULL DEFAULT '0.0',
  `comp_3` varchar(31) NOT NULL DEFAULT '',
  `comp_mpercent_3` float(3,1) NOT NULL DEFAULT '0.0',
  `comp_4` varchar(31) NOT NULL DEFAULT '',
  `comp_mpercent_4` float(3,1) NOT NULL DEFAULT '0.0',
  `comp_5` varchar(31) NOT NULL,
  `comp_mpercent_5` float(3,1) NOT NULL DEFAULT '0.0',
  `comp_6` varchar(31) NOT NULL,
  `comp_mpercent_6` float(3,1) NOT NULL DEFAULT '0.0',
  `comp_7` varchar(31) NOT NULL,
  `comp_mpercent_7` float(3,1) NOT NULL DEFAULT '0.0',
  `evap_1bar` float(5,2) DEFAULT NULL,
  `isent_exp_1bar` float(4,2) DEFAULT NULL,
  `temperature_glide_value` float(4,2) DEFAULT NULL,
  `temperature_glide_at` float(4,2) DEFAULT NULL,
  `critical_temp` float(5,2) DEFAULT NULL,
  `critical_pressure` float(5,2) DEFAULT NULL,
  `odp` float(4,2) DEFAULT NULL,
  `gwp` int(11) DEFAULT NULL,
  `gwp_500` int(11) DEFAULT NULL,
  `combustible` int(6) DEFAULT NULL,
  `safety_group` varchar(255) DEFAULT NULL,
  `mak` int(11) DEFAULT NULL,
  `climatic_cooling` tinyint(4) NOT NULL DEFAULT '0',
  `normal_cooling` tinyint(4) NOT NULL DEFAULT '0',
  `deep_cooling` tinyint(4) NOT NULL DEFAULT '0',
  `rtables_min` int(11) NOT NULL DEFAULT '0',
  `rtables_step` int(11) NOT NULL DEFAULT '0',
  `rtables_max` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refrigerants`
--

LOCK TABLES `refrigerants` WRITE;
/*!40000 ALTER TABLE `refrigerants` DISABLE KEYS */;
INSERT INTO `refrigerants` VALUES ('R134a',1,'1,1,1,2-Tetrafluorethan','1,1,1,2-tetrafluoroethane','HFKW','hfkw_mix','r134a','R\\,134\\,a','$\\mathrm{CH_{2}F\\!-\\!CF_{3}}$',102.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-26.30,NULL,0.00,NULL,101.10,NULL,0.00,1430,NULL,743,'A1',1000,1,1,0,-100,5,100);
INSERT INTO `refrigerants` VALUES ('R600a',1,'Isobutan','2-methyl propane (isobutane)','KW','kw','r600a','R\\,600\\,a','$\\mathrm{CH(CH_{3})_{3}}$',58.10,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-11.90,NULL,0.00,NULL,135.92,NULL,0.00,3,NULL,1,'A3',1000,1,1,1,-100,5,120);
INSERT INTO `refrigerants` VALUES ('R601a',1,'Isopentan','2-methylisopentane','KW','kw','r601a','R\\,601\\,a','$\\mathrm{(CH_{3})_{3}-CH-CH2}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,NULL,NULL,0.00,NULL,NULL,NULL,0.00,5,NULL,1,'A3',0,1,1,1,0,0,0);
INSERT INTO `refrigerants` VALUES ('R740',1,'Argon','Argon',NULL,NULL,'r740','R\\,740','Ar',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-186.00,NULL,0.00,NULL,-122.45,NULL,0.00,0,NULL,NULL,'A1',NULL,0,0,0,-200,10,100);
INSERT INTO `refrigerants` VALUES ('R404A',1,'','',NULL,'hfkw_mix','r404a','R\\,404\\,A','na',0.00,'R143a',52.0,'R125',44.0,'R134a',4.0,'',0.0,'',0.0,'',0.0,'',0.0,-46.40,NULL,0.70,NULL,72.07,NULL,0.00,3922,NULL,728,'A1/A1',1000,0,0,1,-100,5,100);
INSERT INTO `refrigerants` VALUES ('R407C',1,'','',NULL,'hfkw_mix','r407c','R\\,407\\,C','na',0.00,'R32',23.0,'R125',25.0,'R134a',52.0,'',0.0,'',0.0,'',0.0,'',0.0,-43.60,NULL,7.40,0.00,87.00,NULL,0.00,1774,NULL,704,'A1/A1',1000,1,0,0,-85,5,100);
INSERT INTO `refrigerants` VALUES ('R410A',1,'','',NULL,'hfkw_mix','r410a','R\\,410\\,A','na',0.00,'R32',50.0,'R125',50.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-51.60,NULL,0.20,NULL,74.67,NULL,0.00,2088,NULL,NULL,'A1/A1',1000,0,0,0,-100,5,65);
INSERT INTO `refrigerants` VALUES ('R717',1,'Ammoniak','Ammonia','Anorganic','nh3_r723','r717','R\\,717','$\\mathrm{NH_{3}}$',17.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-33.30,NULL,0.00,NULL,132.35,NULL,0.00,0,NULL,630,'B2',20,1,1,1,-75,5,120);
INSERT INTO `refrigerants` VALUES ('R143a',1,'1,1,1-Trifluorethan','','HFKW','hfkw_mix','r143a','R\\,143\\,a','$\\mathrm{CF_{3}\\!-\\!CH_{3}}$',84.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-47.30,NULL,0.00,NULL,73.00,NULL,0.00,4470,NULL,750,'A2',1000,0,0,1,0,0,0);
INSERT INTO `refrigerants` VALUES ('R152a',1,'1,1-Difluorethan','1,1-difluoroethane','HFKW','hfkw_mix','r152a','R\\,152\\,a','$\\mathrm{CHF_{2}\\!-\\!CH_{3}}$',66.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-24.00,NULL,0.00,NULL,113.00,NULL,0.00,124,NULL,455,'A2',1000,1,1,0,-115,5,95);
INSERT INTO `refrigerants` VALUES ('R32',1,'Difluormethan','','HFKW','hfkw_mix','r32','R\\,32','$\\mathrm{CH_{2}F_{2}}$',52.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-51.70,NULL,0.00,NULL,78.00,NULL,0.00,675,NULL,530,'A2',1000,0,1,1,0,0,0);
INSERT INTO `refrigerants` VALUES ('R125',1,'Pentafluorethan','','HFKW','hfkw_mix','r125','R\\,125','$\\mathrm{CF_{3}\\!-\\!CHF_{2}}$',120.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-48.10,NULL,0.00,0.00,NULL,NULL,0.00,3500,NULL,733,'A1',1000,0,0,1,0,0,0);
INSERT INTO `refrigerants` VALUES ('R22',1,'Chlordifluormethan','Chlorodifluoromethane','HFCKW',NULL,'r22','R\\,22','$\\mathrm{CHClF_{2}}$',86.50,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-40.80,NULL,0.00,0.00,96.00,NULL,0.06,1760,NULL,635,'A1',500,1,1,1,-125,5,95);
INSERT INTO `refrigerants` VALUES ('R23',1,'Trifluormethan','Trifluoromethane','HFKW','hfkw_mix','r23','R\\,23','$\\mathrm{CHF_{3}}$',70.01,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-82.00,NULL,0.00,0.00,26.30,48.74,0.00,14800,NULL,765,'A1',1000,0,0,0,-85,5,85);
INSERT INTO `refrigerants` VALUES ('R718',1,'Wasser','Water',NULL,NULL,'r718','R\\,718','$\\mathrm{H_{2}O}$',18.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,100.00,NULL,0.00,NULL,374.14,NULL,0.00,0,NULL,NULL,'A1',NULL,0,0,0,-70,10,400);
INSERT INTO `refrigerants` VALUES ('R764',1,'Schwefeldioxid','',NULL,NULL,'','R\\,764','$\\mathrm{SO_{2}}$',64.10,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-10.20,NULL,0.00,NULL,NULL,NULL,0.00,-1,NULL,NULL,'B1',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R11',1,'','Trichlorofluoromethane','FCKW',NULL,'r11','R\\,11','$\\mathrm{CCl_{3}F}$',137.38,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,23.80,1.12,0.00,0.00,198.01,44.03,1.00,4660,NULL,0,'A1',1000,0,0,0,-65,5,175);
INSERT INTO `refrigerants` VALUES ('R113',1,'','Trichlorotrifluoroethane','FCKW',NULL,'r113','R\\,113','$\\mathrm{CCl_{2}F\\!-\\!CClF_{2}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,47.00,NULL,0.00,NULL,214.10,NULL,0.90,5820,NULL,NULL,'A1',NULL,0,0,0,-30,5,190);
INSERT INTO `refrigerants` VALUES ('R114',1,'','Dichlorotetrafluoroethane','FCKW',NULL,'r114','R\\,114','$\\mathrm{CClF_{2}\\!-\\!CClF_{2}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,3.00,NULL,0.00,0.00,145.70,NULL,0.85,8590,NULL,NULL,'A1',NULL,0,0,0,-90,5,130);
INSERT INTO `refrigerants` VALUES ('R1150',1,'Ethen','Ethene (ethylene)','KW',NULL,'r1150','R\\,1150','$\\mathrm{CH_{2}\\!=\\!CH_{2}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-104.00,NULL,0.00,0.00,9.50,NULL,0.00,4,NULL,NULL,'A3',NULL,0,0,0,-165,5,5);
INSERT INTO `refrigerants` VALUES ('R12',1,'','Dichlorodifluoromethane','FCKW',NULL,'r12','R\\,12','$\\mathrm{CCl_{2}F_{2}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-29.80,1.14,0.00,0.00,112.00,NULL,0.90,10200,NULL,0,'A1',1000,1,1,0,-85,5,110);
INSERT INTO `refrigerants` VALUES ('R123',1,'','Dichlorotrifluoroethane','FCKW',NULL,'r123','R\\,123','$\\mathrm{CHCl_{2}\\!-\\!CF_{3}}$',152.93,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,27.60,1.08,0.00,0.00,183.79,36.74,0.02,79,NULL,0,NULL,100,1,0,0,-55,5,165);
INSERT INTO `refrigerants` VALUES ('R1270',1,'','Propene (propylene)','KW','kw','r1270','R\\,1270','$\\mathrm{CH_{3}\\text{-}CH\\!=\\!CH_{2}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-48.00,NULL,0.00,NULL,91.75,NULL,0.00,2,NULL,NULL,'A3',1000,0,0,0,-160,5,80);
INSERT INTO `refrigerants` VALUES ('R13',1,'','Chlorotrifluoromethane','FCKW',NULL,'r13','R\\,13','$\\mathrm{CClF_{3}}$',104.47,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-81.40,1.14,0.00,NULL,28.78,NULL,1.00,13900,NULL,0,'A1',1000,0,0,0,-170,5,70);
INSERT INTO `refrigerants` VALUES ('R14',1,'',' Tetrafluoromethane','FKW',NULL,'r14','R\\,14','$\\mathrm{CF_{4}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-128.00,NULL,0.00,0.00,-45.70,NULL,0.00,7390,NULL,0,NULL,NULL,0,0,0,-180,5,60);
INSERT INTO `refrigerants` VALUES ('R170',1,'Ethan','Ethane','KW',NULL,'r170','R\\,170','$\\mathrm{CH_{3}\\!-\\!CH_{3}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-89.00,NULL,0.00,NULL,32.73,NULL,0.00,6,NULL,NULL,'A3',NULL,0,0,0,-180,5,80);
INSERT INTO `refrigerants` VALUES ('R21',1,'','Dichlorofluoromethane','FCKW',NULL,'r21','R\\,21','$\\mathrm{CHCl_{2}F}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,8.50,NULL,0.00,0.00,178.50,NULL,NULL,148,NULL,NULL,NULL,NULL,0,0,0,-80,5,150);
INSERT INTO `refrigerants` VALUES ('R290',1,'Propan',' Propane','KW','kw','r290','R\\,290','$\\mathrm{CH_{3}\\text{-}CH_{2}\\text{-}CH_{3}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-42.00,NULL,0.00,NULL,96.67,NULL,0.00,3,NULL,0,'A3',1000,1,1,1,-100,5,100);
INSERT INTO `refrigerants` VALUES ('R50',1,'Methan','Methane','KW',NULL,'r50','R\\,50','$\\mathrm{CH_{4}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-162.00,NULL,0.00,NULL,-82.59,NULL,0.00,28,NULL,NULL,'A2',NULL,0,0,0,-160,10,80);
INSERT INTO `refrigerants` VALUES ('R601',1,'Penan','Pentane','KW',NULL,'','R\\,601','$\\mathrm{CH_{3}\\text{-}(CH_{2})_{3}\\text{-}CH_{3}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,NULL,NULL,0.00,NULL,NULL,NULL,0.00,5,NULL,NULL,'A3',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R728',1,'Stickstoff','Nitrogen','Anorganic',NULL,'r728','R\\,728','$\\mathrm{N_{2}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-196.00,NULL,0.00,NULL,-146.95,NULL,0.00,0,NULL,0,'A1',NULL,0,0,0,-200,5,100);
INSERT INTO `refrigerants` VALUES ('R729',1,'Luft','Air',NULL,NULL,'r729','R\\,729','na',0.00,'R728',76.0,'R732',23.0,'R740',1.0,'',0.0,'',0.0,'',0.0,'',0.0,191.50,NULL,0.00,NULL,-140.65,NULL,0.00,0,NULL,0,'A1',NULL,0,0,0,-200,10,100);
INSERT INTO `refrigerants` VALUES ('R732',1,'Sauerstoff','Oxygen','Anorganic',NULL,'r732','R\\,732','$\\mathrm{O_{2}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-183.00,NULL,0.00,NULL,-118.57,NULL,0.00,0,NULL,0,NULL,NULL,0,0,0,-200,10,100);
INSERT INTO `refrigerants` VALUES ('RC318',1,'','Octafluorocyclobutane',NULL,NULL,'rc318','RC\\,318','$\\mathrm{C_{4}F_{8}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-6.00,NULL,0.00,NULL,115.30,NULL,0.00,10300,NULL,NULL,'A1',NULL,0,0,0,-50,10,100);
INSERT INTO `refrigerants` VALUES ('R401A',1,'','',NULL,'hfkw_mix','r401a','R\\,401\\,A','na',0.00,'R22',53.0,'R152a',13.0,'R124',34.0,'',0.0,'',0.0,'',0.0,'',0.0,-27.00,NULL,NULL,NULL,108.01,NULL,0.04,1130,NULL,NULL,'A1/A1',NULL,1,1,0,-100,5,100);
INSERT INTO `refrigerants` VALUES ('R401B',1,'','',NULL,'hfkw_mix','r401b','R\\,401\\,B','na',0.00,'R22',61.0,'R152a',11.0,'R124',28.0,'',0.0,'',0.0,'',0.0,'',0.0,-29.00,NULL,NULL,NULL,103.68,NULL,0.04,1236,NULL,NULL,'A1/A1',NULL,1,1,0,-100,5,85);
INSERT INTO `refrigerants` VALUES ('R401C',1,'','',NULL,NULL,'r401c','R\\,401\\,C','na',0.00,'R22',33.0,'R152a',15.0,'R124',52.0,'',0.0,'',0.0,'',0.0,'',0.0,-22.00,NULL,NULL,NULL,110.07,NULL,0.03,876,NULL,NULL,'A1/A1',NULL,0,0,0,-100,5,90);
INSERT INTO `refrigerants` VALUES ('R402A',1,'','',NULL,NULL,'r402a','R\\,402\\,A','na',0.00,'R125',60.0,'R290',2.0,'R22',38.0,'',0.0,'',0.0,'',0.0,'',0.0,-47.00,NULL,NULL,NULL,75.50,NULL,0.02,2571,NULL,NULL,'A1/A1',1000,0,1,1,-100,5,100);
INSERT INTO `refrigerants` VALUES ('R402B',1,'','',NULL,'hfkw_mix','r402b','R\\,402\\,B','na',0.00,'R125',38.0,'R290',2.0,'R22',60.0,'',0.0,'',0.0,'',0.0,'',0.0,-45.00,NULL,NULL,NULL,87.05,NULL,0.03,2261,NULL,NULL,'A1/A1',1000,0,1,1,-100,5,70);
INSERT INTO `refrigerants` VALUES ('R406A',1,'','',NULL,NULL,'r406a','R\\,406\\,A','na',89.90,'R22',55.0,'R142b',41.0,'R600a',4.0,'',0.0,'',0.0,'',0.0,'',0.0,-23.00,NULL,NULL,NULL,114.49,NULL,0.06,1780,NULL,NULL,'A1/A2',NULL,0,0,0,-100,5,100);
INSERT INTO `refrigerants` VALUES ('R407A',1,'','',NULL,'hfkw_mix','r407a','R\\,407\\,A','na',0.00,'R32',20.0,'R125',40.0,'R134a',40.0,'',0.0,'',0.0,'',0.0,'',0.0,-46.00,NULL,6.60,NULL,82.36,NULL,0.00,2107,NULL,NULL,'A1/A1',1000,0,0,1,-100,5,65);
INSERT INTO `refrigerants` VALUES ('R407B',1,'','',NULL,'hfkw_mix','r407b','R\\,407\\,B','na',0.00,'R32',10.0,'R125',70.0,'R134a',20.0,'',0.0,'',0.0,'',0.0,'',0.0,-48.00,NULL,4.40,NULL,75.36,NULL,0.00,2804,NULL,NULL,'A1/A1',1000,0,0,1,-50,5,60);
INSERT INTO `refrigerants` VALUES ('R408A',1,'','',NULL,'hfkw_mix','r408a','R\\,408\\,A','na',0.00,'R22',47.0,'R143a',46.0,'R125',7.0,'',0.0,'',0.0,'',0.0,'',0.0,-44.00,NULL,NULL,NULL,83.68,NULL,0.03,3257,NULL,NULL,'A1/A1',NULL,0,0,0,-100,5,100);
INSERT INTO `refrigerants` VALUES ('R409A',1,'','',NULL,'hfkw_mix','r409a','R\\,409\\,A','na',0.00,'R22',60.0,'R124',25.0,'R142b',15.0,'',0.0,'',0.0,'',0.0,'',0.0,-27.00,NULL,NULL,NULL,106.80,NULL,0.05,1485,NULL,NULL,'A1/A1',NULL,0,0,0,-50,5,60);
INSERT INTO `refrigerants` VALUES ('R410B',1,'','',NULL,NULL,'r410b','R\\,410\\,B','na',0.00,'R32',45.0,'R125',55.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-51.50,NULL,NULL,NULL,71.03,NULL,0.00,2229,NULL,NULL,'A1/A1',NULL,0,0,0,-50,5,60);
INSERT INTO `refrigerants` VALUES ('R500',1,'','',NULL,NULL,'r500','R\\,500','na',0.00,'R12',73.8,'R152a',26.2,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-34.00,NULL,0.00,0.00,105.50,NULL,0.74,7560,NULL,NULL,'A1',NULL,0,0,0,-60,5,60);
INSERT INTO `refrigerants` VALUES ('R502',1,'','',NULL,NULL,'r502','R\\,502','na',0.00,'R22',48.8,'R115',51.2,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-46.00,NULL,0.00,0.00,82.20,NULL,0.23,4786,NULL,NULL,'A1',1000,0,1,1,-50,5,60);
INSERT INTO `refrigerants` VALUES ('R507',1,'','',NULL,NULL,'r507','R\\,507','na',0.00,'R125',50.0,'R143a',50.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-47.00,NULL,0.00,NULL,70.90,NULL,0.00,3955,NULL,NULL,'A1',NULL,0,0,1,-95,5,100);
INSERT INTO `refrigerants` VALUES ('R508A',1,'','',NULL,'hfkw_mix','r508a','R\\,508\\,A','na',0.00,'R23',39.0,'R116',61.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-86.00,NULL,0.00,NULL,13.00,NULL,0.00,13214,NULL,NULL,'A1/A1',NULL,0,0,0,-50,5,60);
INSERT INTO `refrigerants` VALUES ('R142b',1,'','','HFCKW','fckw_hfckw','','R\\,142\\,b','$\\mathrm{CClF_{2}\\!-\\!CH_{3}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,NULL,NULL,0.00,NULL,NULL,NULL,0.07,1980,NULL,NULL,'A1',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R124',1,'','','HFCKW','fckw_hfckw','','R\\,124','$\\mathrm{CHClF\\!-\\!CF_{3}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,NULL,NULL,0.00,NULL,NULL,NULL,0.02,527,NULL,NULL,'A1',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R723',1,'','',NULL,'nh3_r723','','R\\,723','na',0.00,'R717',60.0,'RE170',40.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-37.00,NULL,NULL,NULL,131.00,NULL,0.00,8,NULL,NULL,'B2',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('RE170',0,'Dimethylether','','Anorganic',NULL,'','RE\\,170','$\\mathrm{(CH_{3})_{2}O}$',46.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-25.00,NULL,0.00,NULL,NULL,NULL,0.00,-1,NULL,NULL,'A3',1000,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R115',1,'','',NULL,NULL,'','R\\,115','$\\mathrm{CF_{3}\\!-\\!CClF_{2}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,NULL,NULL,0.00,NULL,NULL,NULL,0.40,7670,NULL,NULL,'A1',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R116',1,'','',NULL,NULL,'','R\\,116','$\\mathrm{CF_{3}\\!-\\!CF_{3}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,NULL,NULL,0.00,NULL,NULL,NULL,0.00,12200,NULL,NULL,NULL,NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R409B',1,'','',NULL,'hfkw_mix','','R\\,409\\,B','na',0.00,'R22',65.0,'R124',25.0,'R142b',10.0,'',0.0,'',0.0,'',0.0,'',0.0,-35.00,NULL,NULL,NULL,105.00,NULL,0.05,1474,NULL,NULL,'A1/A1',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R413A',1,'','',NULL,NULL,'','R\\,413\\,A','na',0.00,'R134a',88.0,'R218',9.0,'R600a',3.0,'',0.0,'',0.0,'',0.0,'',0.0,-35.00,NULL,6.90,NULL,101.00,NULL,0.00,2053,NULL,NULL,'A1/A2',1000,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R218',1,'','',NULL,NULL,'','R\\,218','',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,NULL,NULL,0.00,NULL,NULL,NULL,0.00,7000,NULL,NULL,'A1',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R227ea',1,'','',NULL,NULL,'','R\\,227\\,ea','$\\mathrm{CF_{3}\\!-\\!CHF\\!-\\!CF_{3}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-16.00,NULL,0.00,NULL,102.00,NULL,0.00,3220,NULL,NULL,'A1',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R236fa',1,'','',NULL,NULL,'','R\\,236\\,fa','$\\mathrm{CF_{3}\\!-\\!CH_{2}\\!-\\!CF_{3}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-1.00,NULL,0.00,NULL,120.00,NULL,0.00,9810,NULL,NULL,'A1',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R422A',1,'','',NULL,'hfkw_mix','','R\\,422\\,A','na',116.00,'R125',85.1,'R134a',11.5,'R600a',3.4,'',0.0,'',0.0,'',0.0,'',0.0,-49.00,NULL,2.50,NULL,72.00,NULL,0.00,3143,NULL,NULL,'A1/A1',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R417A',1,'','',NULL,'hfkw_mix','','R\\,417\\,A','na',0.00,'R134a',50.0,'R125',46.6,'R600',3.4,'',0.0,'',0.0,'',0.0,'',0.0,-43.00,NULL,5.00,NULL,90.00,NULL,0.00,2346,NULL,NULL,'A1/A1',1000,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R419A',0,'','',NULL,'hfkw_mix','','R\\,419\\,A','na',109.30,'R125',77.0,'R134a',19.0,'RE170',4.0,'',0.0,'',0.0,'',0.0,'',0.0,-43.00,NULL,6.00,NULL,79.00,NULL,0.00,2400,NULL,NULL,'A1/A2',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R508B',1,'','',NULL,'hfkw_mix','','R\\,508\\,B','na',0.00,'R116',54.0,'R23',46.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-88.00,NULL,0.00,NULL,14.00,NULL,0.00,13396,NULL,NULL,'A1/A1',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R744',1,'Kohlenstoffdioxid','Carbon Dioxide','Anorganical',NULL,'r744','R\\,744','$\\mathrm{CO_{2}}$',44.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,-57.00,NULL,0.00,NULL,31.06,46.00,0.00,1,NULL,NULL,'A1',5000,0,0,0,-100,2,200);
INSERT INTO `refrigerants` VALUES ('R611',1,'Methylformiat','methylformate',NULL,NULL,'','R\\,611','$\\mathrm{C_{2}H_{4}O_{2}}$',60.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,NULL,NULL,NULL,NULL,NULL,NULL,0.00,25,NULL,NULL,'B2',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R1234yf',1,'2,3,3,3-Tetrafluoropropen','2,3,3,3-Tetrafluoropropene',NULL,NULL,'','R\\,1234\\,yf','$\\mathrm{CF_{3}\\!-\\!CF\\!=\\!CH_{2}}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R1234ze',1,'1,3,3,3-Tetrafluoropropen','1,3,3,3-Tetrafluoropropene',NULL,NULL,'','R\\,1234\\,ze','$\\mathrm{CF_{3}\\!-\\!CH\\!=\\!CHF}$',0.00,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,'',0.0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,7,NULL,NULL,NULL,NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R407F',1,'','',NULL,'hfkw_mix','','R\\,407\\,F','na',0.00,'R134a',40.0,'R125',30.0,'R32',30.0,'',0.0,'',0.0,'',0.0,'',0.0,-46.00,NULL,6.40,0.00,83.00,NULL,0.00,1825,NULL,0,'A1/A1',1000,0,0,1,0,0,0);
INSERT INTO `refrigerants` VALUES ('R438A',1,'','',NULL,'hfkw_mix','','R\\,438\\,A','na',0.00,'R125',45.0,'R134a',44.2,'R32',8.5,'R600',1.7,'R601a',0.6,'',0.0,'',0.0,NULL,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,'',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R437A',1,'','',NULL,'hfkw_mix','','R\\,437\\,A','na',0.00,'R125',19.5,'R134a',78.5,'R600',1.4,'R601',0.6,'',0.0,'',0.0,'',0.0,NULL,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,'',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R422D',1,'','',NULL,'hfkw_mix','','R\\,422\\,D','na',0.00,'R125',65.1,'R134a',31.5,'R600a',3.4,'',0.0,'',0.0,'',0.0,'',0.0,NULL,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,'',NULL,0,0,0,0,0,0);
INSERT INTO `refrigerants` VALUES ('R449A',1,'','',NULL,'','r449a','R\\,449\\,A','na',0.00,'R134a',26.0,'R1234yf',25.0,'R125',25.0,'R32',25.0,'',0.0,'',0.0,'',0.0,-40.00,NULL,6.20,NULL,80.10,NULL,0.00,1397,NULL,NULL,'A1',NULL,0,0,0,-65,5,85);
/*!40000 ALTER TABLE `refrigerants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `refsym`
--

DROP TABLE IF EXISTS `refsym`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `refsym` (
  `name` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `show_filename` tinyint(4) NOT NULL DEFAULT '1',
  `de` varchar(255) NOT NULL DEFAULT '',
  `add_space` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `refsym`
--

LOCK TABLES `refsym` WRITE;
/*!40000 ALTER TABLE `refsym` DISABLE KEYS */;
INSERT INTO `refsym` VALUES ('lk','',1,'Luftkühler/Lufterhitzer',0);
INSERT INTO `refsym` VALUES ('4-wege','',1,'Vierwegeventil, allgemein',0);
INSERT INTO `refsym` VALUES ('durchfluss','',1,'Durchfluss/Bewegung in Pfeilrichtung',0);
INSERT INTO `refsym` VALUES ('pfeil','',1,'Eingang/Ausgang wichtiger Stoffströme',0);
INSERT INTO `refsym` VALUES ('daemmung','',1,'Rohrleitung, wärmegedämmt',0);
INSERT INTO `refsym` VALUES ('t-stueck1','',1,'T-förmige Verbindung',0);
INSERT INTO `refsym` VALUES ('t-stueck2','',1,'T-förmige Verbindung',0);
INSERT INTO `refsym` VALUES ('kreuz','',1,'Kreuzförmige Verbindung',0);
INSERT INTO `refsym` VALUES ('ventil','',1,'Ventil',0);
INSERT INTO `refsym` VALUES ('ventil2','',1,'Ventil, allgemein',0);
INSERT INTO `refsym` VALUES ('ventil3','',1,'Absperrventil, gegen unbefugte Betätigung gesichert',0);
INSERT INTO `refsym` VALUES ('ventil4','',1,'Ventil, betriebsmässig absperrbar',0);
INSERT INTO `refsym` VALUES ('schieber','',1,'Schieber',0);
INSERT INTO `refsym` VALUES ('kugelhahn','',1,'Kugelhahn',0);
INSERT INTO `refsym` VALUES ('kugelhahn2','',1,'Kugelhahn, gegen unbefugte Betätigung gesichert',0);
INSERT INTO `refsym` VALUES ('eckventil','',1,'Ventil, Eckform, allgemein',0);
INSERT INTO `refsym` VALUES ('eckventil3','',1,'Ventil, Eckform, gegen unbefugte Betätigung gesichert',0);
INSERT INTO `refsym` VALUES ('kugel-eck','',1,'Kugelhahn, Eckform, allgemein',0);
INSERT INTO `refsym` VALUES ('3-wege','',1,'Dreiwegeventil, allgemein',0);
INSERT INTO `refsym` VALUES ('schrader','',1,'Schraderventil',0);
INSERT INTO `refsym` VALUES ('rueckschlag-klappe','',1,'Rückschlagklappe',0);
INSERT INTO `refsym` VALUES ('rueckschlag-ventil2','',1,'Rückschlagventil',0);
INSERT INTO `refsym` VALUES ('pc-ventil1','',1,'Konstantdruckregler',0);
INSERT INTO `refsym` VALUES ('eev','',1,'Elektronisches Expansionsventil',0);
INSERT INTO `refsym` VALUES ('s-ventil2','',1,'Sicherheitsventil, federbelastet, Durchgangsform',0);
INSERT INTO `refsym` VALUES ('berstscheibe','',1,'Berstscheibe',0);
INSERT INTO `refsym` VALUES ('hand-ventil','',1,'Manueller Stellantrieb, Durchgangsform',0);
INSERT INTO `refsym` VALUES ('mag-ventil','',1,'Magnetventil',0);
INSERT INTO `refsym` VALUES ('mot-ventil2','',1,'Stellantrieb mit Elektromotor',0);
INSERT INTO `refsym` VALUES ('feuchte-schauglas','',1,'Schauglas mit Feuchteindikator',0);
INSERT INTO `refsym` VALUES ('filtertrockner','',1,'Filtertrockner',0);
INSERT INTO `refsym` VALUES ('schalldaempfer','',1,'Schalldämpfer (Muffler)',0);
INSERT INTO `refsym` VALUES ('loesbar','',1,'Lösbare Verbindung',0);
INSERT INTO `refsym` VALUES ('kompensator','',1,'Rohrleitungskompensator',0);
INSERT INTO `refsym` VALUES ('sammler-stehend-1','',1,'Sammler, stehend',0);
INSERT INTO `refsym` VALUES ('wue','',1,'Wärmeübertrager mit Kreuzung der Fließlinien',0);
INSERT INTO `refsym` VALUES ('wue2','',1,'Wärmeübertrager ohne Kreuzung der Fließlinien',0);
INSERT INTO `refsym` VALUES ('rohrbuendel','',1,'Rohrbündel-Wärmeübertrager mit Festböden',0);
INSERT INTO `refsym` VALUES ('doro-wue','',1,'Doppelrohr-Wärmeübertrager',0);
INSERT INTO `refsym` VALUES ('lk-still','',1,'Stiller Luftkühler',0);
INSERT INTO `refsym` VALUES ('abscheider','',1,'Abscheider, allgemein',0);
INSERT INTO `refsym` VALUES ('prallabscheider','',1,'Prallabscheider',0);
INSERT INTO `refsym` VALUES ('oelabscheider','',1,'Ölabscheider mit Schwimmerausschleusung',0);
INSERT INTO `refsym` VALUES ('verdichter','',1,'Verdichter, Vakuumpumpe, allgemein',0);
INSERT INTO `refsym` VALUES ('hubkolben','',1,'Hubkolbenverdichter, Hubkolben-Vakuumpumpe',0);
INSERT INTO `refsym` VALUES ('scroll','',1,'Spiralverdichter (Scroll)',0);
INSERT INTO `refsym` VALUES ('drehkolben','',1,'Drehkolbenverdichter, Drehkolben-Vakuumpumpe',0);
INSERT INTO `refsym` VALUES ('schraube','',1,'Schraubenverdichter',0);
INSERT INTO `refsym` VALUES ('turbo','',1,'Turboverdichter, Turbo-Vakuumpumpe',0);
INSERT INTO `refsym` VALUES ('mot','',1,'Elektromotor, allgemein',0);
INSERT INTO `refsym` VALUES ('mot-1','',1,'Wechselstrom-Motor, allgemein',0);
INSERT INTO `refsym` VALUES ('mot-3','',1,'Drehstrom-Motor, allgemein',0);
INSERT INTO `refsym` VALUES ('mot-gleich','',1,'Gleichstrom-Motor, allgemein',0);
INSERT INTO `refsym` VALUES ('mot-verb','',1,'Verbrennungsmaschine',0);
INSERT INTO `refsym` VALUES ('hermetisch','',1,'Hermetische Verbindung Motor---Verdichter',0);
INSERT INTO `refsym` VALUES ('kuehlturm','',1,'Kühlturm, allgemein',0);
INSERT INTO `refsym` VALUES ('kuehlturm2','',1,'Kühlturm mit saugendem Ventilator',0);
INSERT INTO `refsym` VALUES ('ververf','',1,'Verdunstungsverflüssiger mit saugendem Ventilator',0);
INSERT INTO `refsym` VALUES ('pumpe','',1,'Pumpe, allgemein',0);
INSERT INTO `refsym` VALUES ('kreisel','',1,'Kreiselpumpe',0);
INSERT INTO `refsym` VALUES ('hubkolbenpumpe','',1,'Hubkolbenpumpe',0);
INSERT INTO `refsym` VALUES ('membran','',1,'Membranpumpe',0);
INSERT INTO `refsym` VALUES ('zahnrad','',1,'Zahnradpumpe',0);
INSERT INTO `refsym` VALUES ('schraubenspindel','',1,'Schraubenspindelpumpe',0);
INSERT INTO `refsym` VALUES ('strahl','',1,'Strahlflüssigkeitspumpe',0);
INSERT INTO `refsym` VALUES ('ps','',1,'Druckschalter',0);
INSERT INTO `refsym` VALUES ('pdi','',1,'Differenz-Druckmessgerät',0);
INSERT INTO `refsym` VALUES ('pzh','',1,'Druckbegrenzer für steigenden Druck',0);
INSERT INTO `refsym` VALUES ('pc','',1,'Druck-Regelung/Steuerung',0);
INSERT INTO `refsym` VALUES ('psh','',1,'Druckschalter für steigenden Druck',0);
INSERT INTO `refsym` VALUES ('psl','',1,'Druckschalter für fallenden Druck',0);
INSERT INTO `refsym` VALUES ('pi','',1,'Druckmessgerät',0);
INSERT INTO `refsym` VALUES ('pdzah','',1,'Sicherheits-Differenzdruckschalter, Einstellung/Alarm max.',0);
INSERT INTO `refsym` VALUES ('pzhh','',1,'Sicherheitsdruckbegrenzer für steigenden Druck',0);
INSERT INTO `refsym` VALUES ('ls','',1,'Füllstandschalter',0);
INSERT INTO `refsym` VALUES ('lzah','',1,'Füllstandbegrenzer, Einstellwert/Alarm max.',0);
INSERT INTO `refsym` VALUES ('ti','',1,'Thermometer',0);
INSERT INTO `refsym` VALUES ('tzal','',1,'Temperaturbegrenzer, Einstellung/Alarm min.',0);
INSERT INTO `refsym` VALUES ('tshl','',1,'Temperaturschalter',0);
INSERT INTO `refsym` VALUES ('li','',1,'Füllstandanzeige',0);
INSERT INTO `refsym` VALUES ('tzah','',1,'Temperaturbegrenzer, Einstellung/Alarm max.',0);
INSERT INTO `refsym` VALUES ('lzal','',1,'Füllstandbegrenzer, Einstellwert/Alarm min.',0);
INSERT INTO `refsym` VALUES ('fzal','',1,'Strömungsbegrenzer, durch Strömung betätigt, Einstellwert/Alarm min.',0);
INSERT INTO `refsym` VALUES ('fzah','',1,'Strömungsbegrenzer, durch Strömung betätigt, Einstellwert/Alarm max.',0);
INSERT INTO `refsym` VALUES ('li-A','',1,'Standzeiger',0);
INSERT INTO `refsym` VALUES ('pzal','',1,'Druckbegrenzer, Einstellung/Alarm min.',0);
INSERT INTO `refsym` VALUES ('pzah','',1,'Druckbegrenzer, Einstellung/Alarm max.',0);
INSERT INTO `refsym` VALUES ('pdzal','',1,'Sicherheits-Differenzdruckschalter, Einstellung/Alarm min.',0);
INSERT INTO `refsym` VALUES ('sammler-liegend-1','',1,'Sammler, liegend',0);
INSERT INTO `refsym` VALUES ('vent','',1,'Ventilator',0);
INSERT INTO `refsym` VALUES ('axial','',1,'Ventilator, Axial',0);
INSERT INTO `refsym` VALUES ('radial','',1,'Ventilator, Radial',0);
INSERT INTO `refsym` VALUES ('kapillare2','',1,'Kapillare',0);
INSERT INTO `refsym` VALUES ('kapillare1','',1,'Kapillare',0);
INSERT INTO `refsym` VALUES ('tev','',1,'Thermostatisches Expansionsventil',0);
INSERT INTO `refsym` VALUES ('ruehrer','',1,'Rührer, allgemein',0);
INSERT INTO `refsym` VALUES ('prop-ruehrer','',1,'Propellerrührer',0);
INSERT INTO `refsym` VALUES ('hauptfliess','',0,'Kältemittel, Kältemittellösungen, Hauptkreislauf (\\unit{1,0}{\\milli\\metre})',0);
INSERT INTO `refsym` VALUES ('nebenfliess','',0,'Kältemittel, Nebenkreislauf (\\unit{0,5}{\\milli\\metre})',0);
INSERT INTO `refsym` VALUES ('waermetraeger','',0,'Wärmeträger (\\unit{0,5}{\\milli\\metre})',0);
INSERT INTO `refsym` VALUES ('verfwasser','',0,'Kühlwasser für Verflüssiger (\\unit{0,25}{\\milli\\metre})',0);
INSERT INTO `refsym` VALUES ('sonstiges','',0,'Sonstige Stoffe (z. B. Öl), (\\unit{0,25}{\\milli\\metre})',0);
INSERT INTO `refsym` VALUES ('30-wirklinie','',1,'Wirklinie, allgemein (\\unit{0,25}{\\milli\\metre})',0);
INSERT INTO `refsym` VALUES ('deltat','',0,'zu kühlender oder zu erwärmender Stoff (einschl. Wasser), (\\unit{0,25}{\\milli\\metre})',0);
INSERT INTO `refsym` VALUES ('kreuz-ohne','',1,'Überschneidung von Fließlinien ohne Verbindung',0);
INSERT INTO `refsym` VALUES ('rohrschlange','',1,'Wärmeübertrager mit Rohrschlange',0);
INSERT INTO `refsym` VALUES ('rohru','',1,'Rohrbündel-Wärmeübertrager mit U-Rohr',0);
INSERT INTO `refsym` VALUES ('rohrschwimm','',1,'Rohrbündel-Wärmeübertrager mit Schwimmkopf',0);
INSERT INTO `refsym` VALUES ('schlauch','',1,'Schlauchleitung',0);
INSERT INTO `refsym` VALUES ('schauglas','',1,'Schauglas',0);
INSERT INTO `refsym` VALUES ('gasflasche','',1,'Gasflasche',0);
INSERT INTO `refsym` VALUES ('trichter','',1,'Trichter',0);
INSERT INTO `refsym` VALUES ('auslass','',1,'Auslaß zur Atmosphäre',0);
INSERT INTO `refsym` VALUES ('nd-schwimmer','',1,'Niederdruck-Schwimmer (öffnet bei fallendem Stand)',0);
INSERT INTO `refsym` VALUES ('hd-schwimmer','',1,'Hochdruck-Schwimmer (öffnet bei steigendem Stand)',0);
INSERT INTO `refsym` VALUES ('beheizt','',1,'Rohrleitung beheizt oder gekühlt',0);
INSERT INTO `refsym` VALUES ('s-ventil','',1,'Sicherheitsventil, breiter Strich an Austrittseite',0);
INSERT INTO `refsym` VALUES ('prop-mot','',1,'Propellerrührer mit Motor',0);
INSERT INTO `refsym` VALUES ('rueckschlag-ventil','',1,'Rückschlagventil',0);
INSERT INTO `refsym` VALUES ('mot-ventil','',1,'Stellantrieb mit Elektromotor',0);
INSERT INTO `refsym` VALUES ('verkreuz','',1,'Kreuzförmige Verbindung, versetzt',0);
INSERT INTO `refsym` VALUES ('sammler-stehend-2','',1,'Sammler, stehend',0);
/*!40000 ALTER TABLE `refsym` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `substances`
--

DROP TABLE IF EXISTS `substances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `substances` (
  `name` varchar(255) NOT NULL DEFAULT '',
  `Type` int(11) DEFAULT NULL,
  `int_metal_number` varchar(64) NOT NULL DEFAULT '',
  `en` varchar(255) DEFAULT NULL,
  `de` varchar(255) DEFAULT NULL,
  `de_comment` varchar(255) DEFAULT NULL,
  `it` varchar(255) DEFAULT NULL,
  `Melting_Point` float(6,2) DEFAULT NULL,
  `Vapour_Point` float(7,2) DEFAULT NULL,
  `Density` float(6,4) DEFAULT NULL,
  `Heat_Capacity_Solid` float(6,4) DEFAULT NULL,
  `Heat_Capacity_Liquid` float(6,4) DEFAULT NULL,
  `Heat_Capacity_Gas` float(6,4) DEFAULT NULL,
  `Heat_of_Fusion` float(6,2) DEFAULT NULL,
  `Heat_of_Vapour` float(7,2) DEFAULT NULL,
  `Heat_of_Breathe` float(6,2) DEFAULT NULL,
  `Store_Temperature` float(5,2) DEFAULT NULL,
  `Store_Temperature_2` float(5,2) DEFAULT NULL,
  `Store_Humidity` varchar(255) DEFAULT NULL,
  `Store_Duration` varchar(31) DEFAULT NULL,
  `Store_Temperature_Fresh` float(5,2) DEFAULT NULL,
  `Store_Temperature_Fresh_2` float(5,2) DEFAULT NULL,
  `Store_Humidity_Fresh` varchar(255) DEFAULT NULL,
  `Store_Duration_Fresh` varchar(31) DEFAULT NULL,
  `Store_Temperature_Frozen` float(5,2) DEFAULT NULL,
  `Store_Humidity_Frozen` varchar(255) DEFAULT NULL,
  `Store_Duration_Frozen` varchar(31) DEFAULT NULL,
  `Heat_Conductivity` float(8,4) DEFAULT NULL,
  `Thermal_Expansion` float(8,4) DEFAULT NULL,
  `Electrical_Conductivity` float(8,4) DEFAULT NULL,
  `Heat_Value_Lower` int(11) DEFAULT NULL,
  `Heat_Value_Upper` int(11) DEFAULT NULL,
  `Heat_Value_Lower_n` int(11) DEFAULT NULL,
  `Heat_Value_Upper_n` int(11) DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `substances`
--

LOCK TABLES `substances` WRITE;
/*!40000 ALTER TABLE `substances` DISABLE KEYS */;
INSERT INTO `substances` VALUES ('titan',100,'','titan','Titan','',NULL,1660.00,3287.00,4.5000,0.5280,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,26.0000,8.2000,54.0000,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('copper',100,'','copper','Kupfer','',NULL,1083.00,2330.00,8.9600,0.3850,NULL,NULL,204.80,4647.30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,394.0000,16.5000,1.7000,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('peas',5,'','Peas','Erbsen','',NULL,-1.00,NULL,NULL,1.7600,3.3100,NULL,246.00,NULL,9.60,0.00,NULL,'90-95','7-21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('sausage',1,'','Sausage','Wurst','',NULL,-2.00,NULL,NULL,2.3400,3.7200,NULL,216.00,NULL,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'85-90','3-12',-18.00,'90-95','60-180',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('mussels',2,'','Mussels','Muscheln','',NULL,-2.00,NULL,NULL,1.8800,3.6200,NULL,277.00,NULL,NULL,NULL,NULL,NULL,NULL,-1.00,NULL,'85-95','3-7',-18.00,'90-95','90-240',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('beer',4,'','Beer','Bier','',NULL,-2.00,NULL,NULL,NULL,3.8500,NULL,NULL,NULL,NULL,5.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('bread',4,'','Bread','Brot','',NULL,-2.00,NULL,NULL,1.4200,2.9300,NULL,115.00,NULL,NULL,-18.00,NULL,NULL,'120-180',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('apples',6,'','Apples','Äpfel','',NULL,-2.00,NULL,NULL,1.8800,3.6400,NULL,281.00,NULL,1.90,-1.00,-3.00,'90','30-180',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('alu',100,'','Aluminium','Aluminium','',NULL,659.00,2270.00,2.7000,0.8960,NULL,NULL,396.07,11723.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,209.0000,23.8000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('water',110,'','Water','Wasser','',NULL,0.00,100.00,1.0000,2.0930,4.1800,2.0100,333.70,2256.20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,180.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('chicken',1,'','','Geflügel','',NULL,-3.00,NULL,NULL,1.7600,3.3000,NULL,246.00,NULL,NULL,NULL,NULL,'',NULL,0.00,NULL,'85-90','7',-18.00,'90-95','240-365',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('calv',1,'',NULL,'Kalbfleisch','',NULL,-2.00,NULL,NULL,1.6700,3.0800,NULL,223.00,NULL,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'90-95','5-10',-18.00,'90-95','240-300',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('lamb',1,'',NULL,'Lammfleisch','',NULL,-2.00,NULL,NULL,1.8600,3.0000,NULL,216.00,NULL,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'85-90','5-12',-18.00,'90-95','240-300',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('rind',1,'',NULL,'Rindfleisch','',NULL,-2.00,NULL,NULL,1.7600,3.2500,NULL,235.00,NULL,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'85-90','5-10',-18.00,'90-95','240-300',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('pork',1,'',NULL,'Schweinefleisch','',NULL,-2.00,NULL,NULL,1.3000,2.1300,NULL,128.00,NULL,NULL,NULL,NULL,NULL,NULL,0.00,NULL,'85-90','3-7',-18.00,'90-95','---',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('bacon',1,'','Bacon','Speck','',NULL,-2.00,NULL,NULL,1.2000,1.5300,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1.00,-4.00,'85','14-42',-18.00,'90-95','120-180',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('fish',2,'','Fish','Fisch','',NULL,-2.00,NULL,NULL,1.7400,3.2600,NULL,245.00,NULL,NULL,NULL,NULL,NULL,NULL,1.00,NULL,'90-95','5-15',-18.00,'90-95','180-365',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('fish_smoked',2,'','Smoked Fish','Fisch (geräuchert)','',NULL,-2.00,NULL,NULL,1.6300,2.9300,NULL,213.00,NULL,NULL,4.00,9.00,'50-60','180-240',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('butter',3,'','Butter','Butter','',NULL,-6.00,NULL,NULL,1.2500,2.3800,NULL,153.00,NULL,NULL,NULL,NULL,NULL,NULL,0.00,4.00,'80-85','60',-18.00,'70-85','240-365',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('eggs',3,'','Eggs (fresh)','Eier (frisch)','',NULL,-2.00,NULL,NULL,1.6800,3.1800,NULL,235.00,NULL,NULL,0.00,NULL,'85-90','365',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('cheese',3,'','Cheese','Käse','',NULL,-2.00,NULL,NULL,1.3000,2.1000,NULL,126.00,NULL,NULL,-1.00,NULL,'65-70',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('milk',3,'','Milk','Milch','',NULL,-1.00,NULL,NULL,2.5100,3.7700,NULL,290.00,NULL,NULL,1.00,NULL,NULL,'7',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('cream',3,'','Cream','Sahne','',NULL,-3.00,NULL,NULL,1.7600,3.2700,NULL,242.00,NULL,NULL,NULL,NULL,NULL,NULL,0.00,NULL,NULL,NULL,-18.00,'','60-90',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('icecream',3,'','Ice Cream','Speiseeis','',NULL,-2.00,NULL,NULL,1.6300,2.9300,NULL,207.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,-18.00,'---','30-60',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('margarine',4,'','Margarine','Margarine','',NULL,-5.00,NULL,NULL,1.2500,2.4300,NULL,151.00,NULL,NULL,2.00,NULL,'60-70','365',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('artichokes',5,'','Artichokes','Artischocken','',NULL,-1.00,NULL,NULL,1.8800,3.6400,NULL,280.00,NULL,NULL,0.00,NULL,'90-95','7-14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('cauliflower',5,'','Cauliflower','Blumenkohl','',NULL,-1.00,NULL,NULL,1.9700,3.8900,NULL,307.00,NULL,4.50,0.00,NULL,'90-95','14-28',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('beans',5,'','Beans','Grüne Bohnen','',NULL,-1.00,NULL,NULL,1.9700,3.8900,NULL,298.00,NULL,11.60,4.00,7.00,'90-95','7-10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('mushrooms',5,'','Mushrooms','Champignons','',NULL,-1.00,NULL,NULL,1.9700,3.8900,NULL,302.00,NULL,7.20,0.00,NULL,'90','3-4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('gherkins',5,'','Gherkin','Gurken','',NULL,-1.00,NULL,NULL,2.0500,4.0600,NULL,319.00,NULL,NULL,7.00,9.00,'90-95','10-14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('potatoes',5,'','Potatoes','Kartoffeln (Spät-)','',NULL,-1.00,NULL,NULL,1.8000,3.4300,NULL,NULL,NULL,1.80,3.00,9.00,'90',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('cabbage',5,'','Cabbage','Kohl','',NULL,-1.00,NULL,NULL,1.9700,3.9400,NULL,307.00,NULL,1.40,0.00,NULL,'90-95','90-120',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('leek',5,'','Leek','Lauch','',NULL,-1.00,NULL,NULL,1.9300,3.6800,NULL,293.00,NULL,NULL,0.00,NULL,'90-95','30-90',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('corn',5,'','Corn','Mais','',NULL,-1.00,NULL,NULL,1.7600,3.3100,NULL,246.00,NULL,10.80,0.00,NULL,'90-95','4-8',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('melons',5,'','Melons','Melonen','',NULL,0.00,NULL,NULL,2.0000,4.0600,NULL,307.00,NULL,1.50,2.00,4.00,'80-85','5-15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('carrots',5,'','Carrots','Karotten','',NULL,-1.00,NULL,NULL,1.9300,3.7600,NULL,293.00,NULL,2.40,0.00,NULL,'90-95','120-150',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('olives',5,'','Olives','Oliven','',NULL,-2.00,NULL,NULL,1.7600,3.3500,NULL,251.00,NULL,1.00,7.00,9.00,'85-90','28-42',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('rhubarb',5,'','Rhubarb','Rhabarber','',NULL,-1.00,NULL,NULL,2.0000,4.0200,NULL,312.00,NULL,NULL,0.00,NULL,'95','14-28',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('sprouts',5,'','Sprouts','Rosenkohl','',NULL,-1.00,NULL,NULL,1.9300,3.6800,NULL,284.00,NULL,6.70,0.00,NULL,'90-95','21-35',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('salad',5,'','Salad','Salat','',NULL,0.00,NULL,NULL,2.0000,4.0200,NULL,316.00,NULL,3.90,0.00,NULL,'95','14-21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('celery',5,'','Celery','Sellerie','',NULL,-1.00,NULL,NULL,2.0000,3.9800,NULL,314.00,NULL,1.90,0.00,NULL,'90-95','60-90',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('asparagus',5,'','Asparagus','Spargel','',NULL,-1.00,NULL,NULL,2.0000,3.9400,NULL,312.00,NULL,11.10,0.00,2.00,'95','14-21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('spinach',5,'','Spinach','Spinat','',NULL,0.00,NULL,NULL,2.0000,3.9400,NULL,307.00,NULL,11.10,0.00,NULL,'90-95','10-14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('tomatoes',5,'','Tomatoes','Tomaten (reif)','',NULL,-1.00,NULL,NULL,2.0000,3.9400,NULL,312.00,NULL,4.30,7.00,9.00,'85-90','4-7',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('onions',5,'','Onions','Zwiebel','',NULL,-1.00,NULL,NULL,1.9300,3.7700,NULL,288.00,NULL,1.00,0.00,NULL,'65-70','30-240',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('pineapple',6,'','Pineapple','Ananas (reif)','',NULL,-1.00,NULL,NULL,1.8800,3.6800,NULL,283.00,NULL,NULL,7.00,NULL,'85-90','14-28',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('avocados',6,'','Avocados','Avocados','',NULL,0.00,NULL,NULL,1.6700,3.0100,NULL,219.00,NULL,25.60,7.00,13.00,'85-90','14-28',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('apricots',6,'','Apricots','Aprikosen','',NULL,-1.00,NULL,NULL,1.9200,3.6800,NULL,284.00,NULL,NULL,0.00,NULL,'90','7-14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('bananas',6,'','Bananas','Bananen','',NULL,-1.00,NULL,NULL,1.7600,3.3500,NULL,251.00,NULL,NULL,13.00,15.00,'90','5-10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('strawberries',6,'','Strawberries','Erdbeeren','',NULL,-1.00,NULL,NULL,1.7600,3.8500,NULL,300.00,NULL,3.80,0.00,NULL,'90-95','5-7',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('raspberries',6,'','Raspberries','Himbeeren','',NULL,-1.00,NULL,NULL,1.8600,3.5600,NULL,284.00,NULL,5.50,0.00,-5.00,'90-95','2-3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('blackcurrant',6,'','Black currant','Johannisbeeren','',NULL,-1.00,NULL,NULL,1.8800,3.6800,NULL,280.00,NULL,NULL,0.00,NULL,'90-95','10-14',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('cranberry',6,'','Cranberry','Preiselbeeren','',NULL,-1.00,NULL,NULL,1.9300,3.7700,NULL,288.00,NULL,1.10,2.00,4.00,'90-95','60-120',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('gooseberries',6,'','Gooseberries','Stachelbeeren','',NULL,-1.00,NULL,NULL,1.9300,3.7700,NULL,293.00,NULL,NULL,0.00,NULL,'90-95','14-28',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('pears',6,'','Pears','Birnen','',NULL,-2.00,NULL,NULL,1.8800,3.6000,NULL,274.00,NULL,0.90,-1.00,NULL,'90-95','14-49',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('dates',6,'','Dates','Datteln (getrocknet)','',NULL,-16.00,NULL,NULL,1.0800,1.5100,NULL,67.00,NULL,NULL,0.00,-18.00,'<75','180-365',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('figs',6,'','Figs','Feigen (getrocknet)','',NULL,NULL,NULL,NULL,1.1300,1.6300,NULL,80.00,NULL,NULL,0.00,4.00,'50-60','270-365',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('cherries',6,'','Cherries','Kirschen','',NULL,-2.00,NULL,NULL,1.8800,3.6400,NULL,280.00,NULL,1.80,0.00,NULL,'90-95','14-21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('coconuts',6,'','Coconuts','Kokosnüsse','',NULL,-1.00,NULL,NULL,1.4200,2.4300,NULL,156.00,NULL,NULL,0.00,2.00,'80-85','30-60',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('tangerines',6,'','Tangerines','Mandarinen','',NULL,-1.00,NULL,NULL,1.9300,3.7700,NULL,290.00,NULL,NULL,0.00,3.00,'90-95','14-28',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('oranges',6,'','Oranges','Orangen','',NULL,-1.00,NULL,NULL,1.9200,3.7700,NULL,288.00,NULL,1.70,0.00,9.00,'85-90','21-84',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('grapefruit',6,'','Grapefruit','Pampelmusen','',NULL,-1.00,NULL,NULL,1.9300,3.8100,NULL,293.00,NULL,3.60,10.00,16.00,'85-90','28-42',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('peaches',6,'','Peaches','Pfirsiche','',NULL,-1.00,NULL,NULL,1.9200,3.7700,NULL,288.00,NULL,1.30,0.00,NULL,'90','14-28',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('grapes',6,'','Grapes','Weintrauben','',NULL,-2.00,NULL,NULL,1.8400,3.6000,NULL,270.00,NULL,0.40,-1.00,0.00,'85-90','30-180',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('lemons',6,'','Lemons','Zitronen','',NULL,-1.00,NULL,NULL,1.9300,3.8100,NULL,295.00,NULL,4.20,14.00,16.00,'85-90','30-180',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('beetroot',5,'','Beetroot','Rote Beete','',NULL,-1.00,NULL,NULL,1.9200,3.7700,NULL,293.00,NULL,3.10,0.00,NULL,'95','90-150',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('brass',100,'','Brass','Messing','',NULL,950.00,2300.00,8.5500,0.3890,NULL,NULL,167.50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,105.0000,18.5000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('steel',100,'','Steel','Stahl','',NULL,1460.00,2500.00,7.8500,0.4600,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50.0000,11.5000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('cast_iron',100,'','Cast Iron','Gusseisen','',NULL,1175.00,2500.00,7.2500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,58.0000,10.5000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('zinc',100,'','Zinc','Zink','',NULL,419.50,907.00,7.1300,0.3850,NULL,NULL,104.70,1800.30,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,110.0000,29.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('tin',100,'','Tin','Zinn','',NULL,231.90,2687.00,7.2900,0.2260,NULL,NULL,58.60,2595.80,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64.0000,23.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('silver',100,'','Silver','Silber','',NULL,961.50,2180.00,10.5000,0.2510,NULL,NULL,104.70,2177.10,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,418.7000,19.7000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('x12crni188',100,'','X 12 CrNi 18 8','X 12 CrNi 18 8','',NULL,1450.00,NULL,7.9000,0.5100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14.0000,16.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('quicksilver',110,'','Quicksilver','Quecksilber','',NULL,-39.00,357.00,13.5460,NULL,0.1380,NULL,11.80,284.70,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8.4000,180.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('iron',100,'','Iron','Eisen','',NULL,1536.00,3070.00,7.8700,0.4600,NULL,NULL,272.14,6364.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('gold',100,'','Gold','Gold','',NULL,1064.00,2707.00,19.3000,0.1300,NULL,NULL,64.48,1758.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,311.0000,14.2000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('platinum',100,'','Platinum','Platin','',NULL,1769.00,4300.00,21.5000,0.1310,NULL,NULL,111.40,2512.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,80.0000,9.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('cotton',205,'','Cotton','Baumwolle','',NULL,NULL,NULL,0.0800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0400,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('clay_1',202,'','Clay','Lehmbaustoffe','',NULL,NULL,NULL,0.6000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.1700,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('glass_wool',205,'','Glass wool','Glaswolle','',NULL,NULL,NULL,0.1100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0400,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('wood_1',202,'',NULL,'Sperrholz','',NULL,NULL,NULL,0.5000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.1300,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('wood_3',202,'',NULL,'Konstruktionsholz','',NULL,NULL,NULL,0.5000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.1300,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('fuel_oil',110,'','Fuel Oil','Heizöl','',NULL,-10.00,175.00,0.8300,NULL,2.0700,NULL,NULL,628.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.1400,960.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('machine_oil',110,'','Machine Oil','Maschinenöl','',NULL,-20.00,300.00,0.9100,NULL,2.0900,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.1300,930.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('ethanol',110,'','','Ethanol (Alkohol)','',NULL,-114.00,78.30,0.7900,NULL,2.4150,NULL,108.02,858.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1100.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('air',115,'','Air','Luft','',NULL,-220.00,-191.00,0.0013,NULL,NULL,1.0050,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0260,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('hydrogen',115,'','Hydrogen','Wasserstoff','',NULL,-259.00,-253.00,0.0001,NULL,NULL,14.2400,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.1800,NULL,NULL,NULL,NULL,119970,141800);
INSERT INTO `substances` VALUES ('acetylene',115,'','Acetylene','Acetylen','',NULL,-84.00,-82.00,0.0017,NULL,NULL,1.6400,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0210,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('helium',115,'','Helium','Helium','',NULL,NULL,NULL,NULL,NULL,NULL,5.2750,NULL,25.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('concrete_3',202,'','Reinforced Concrete','Stahlbeton (\\unit{1}{\\%} Stahl)','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2.3000,10.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('x5crni1810',100,'1.4301','X 5 CrNi 18 10','X 5 CrNi 18 10 (V2A)','',NULL,NULL,NULL,7.9000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15.0000,16.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('x5crnimo1712 2',100,'1.4401','X 5 CrNiMo 17 12 2','X 5 CrNiMo 17 12 2 (V4A)','',NULL,NULL,NULL,7.9500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15.0000,16.5000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('plumbum',100,'','Lead','Blei','',NULL,327.40,1751.00,11.3000,0.1270,NULL,NULL,24.79,921.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34.7000,29.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('brick',202,'','Brick','Ziegel','Durchschnittswert',NULL,NULL,NULL,0.6500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.1000,0.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('sand_lime',202,'','Sand-lime brick','Kalksandstein','Durchschnittswert',NULL,NULL,NULL,0.8000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.8000,0.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('poroton',202,'','','Porenbeton','Durchschnittswert',NULL,NULL,NULL,0.3500,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.1000,0.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('plaster_4',202,'',NULL,'Wärmedämmputz','DIN 18550-3, WLG 100',NULL,NULL,NULL,0.2000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.1000,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('argon',115,'',NULL,'Argon',NULL,NULL,NULL,NULL,0.0017,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0170,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('krypton',115,'',NULL,'Krypton',NULL,NULL,NULL,NULL,0.0036,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0090,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('carbon_dioxide',115,'',NULL,'Kohlenstoffdioxid',NULL,NULL,NULL,NULL,0.0019,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0140,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('concrete_1',202,'','Concrete','Beton (mittlere Rohdichte)','',NULL,NULL,NULL,2.0000,0.8800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1.3500,10.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('concrete_2',202,'','Concrete','Beton (hohe Rohdichte)','',NULL,NULL,NULL,2.4000,0.8800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2.0000,10.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('concrete_4',202,'','Reinforced Concrete','Stahlbeton (\\unit{2}{\\%} Stahl)','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2.5000,10.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('xenon',115,'',NULL,'Xenon',NULL,NULL,NULL,NULL,0.0057,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0054,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('glas_1',202,'',NULL,'Natronglas (einschl. Floatglas)','',NULL,NULL,NULL,2.5000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1.0000,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('glas_2',202,'',NULL,'Quarzglas','',NULL,NULL,NULL,2.2000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1.4000,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('plaster_1',202,'','Plaster','Gips','',NULL,NULL,NULL,1.2000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.4300,0.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('wood_2',202,'',NULL,'Sperrholz','',NULL,NULL,NULL,1.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.2400,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('wood_4',202,'',NULL,'Konstruktionsholz','',NULL,NULL,NULL,0.7000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.1800,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('plaster_3',202,'',NULL,'Wärmedämmputz','DIN 18550-3, WLG 060',NULL,NULL,NULL,0.2000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0600,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('plaster_5',202,'',NULL,'Leichtputz','$\\varrho \\leq \\unit{700}{\\kilo\\gram\\per\\cubicmetre}$',NULL,NULL,NULL,0.7000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.2500,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('mineral_wool',205,'',NULL,'Mineralwolle','DIN EN 13162, Kategorie I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0300,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('perlit',205,'',NULL,'Blähperlit','DIN EN 13169, Kategorie I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0380,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('cork',205,'',NULL,'Expandierter Kork','DIN EN 13170, Kategorie I',NULL,NULL,NULL,0.3000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0410,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('wood_10',205,'',NULL,'Holzfaserdämmstoff','DIN EN 13171, Kategorie I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0350,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('polystyrol',205,'',NULL,'Expandierter Polystyrolschaum','DIN EN 13163, Kategorie I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0300,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('polystyrol_2',205,'',NULL,'Extrudierter Polystyrolschaum','DIN EN 13164, Kategorie I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0260,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('polyurethan',205,'',NULL,'Polyurethan-Hartschaum','DIN EN 13165, Kategorie I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0200,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('pheneol',205,'',NULL,'Phenolharz-Hartschaum','DIN EN 13166, Kategorie I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0200,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('foam_glas',205,'',NULL,'Schaumglas','DIN EN 13167, Kategorie I',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0380,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('clay_2',202,'','Clay','Lehmbaustoffe','',NULL,NULL,NULL,1.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.3500,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('plaster_2',202,'','Plaster','Gips/Gipsdämmputz','',NULL,NULL,NULL,0.6000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.1800,0.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('plaster_6',NULL,'',NULL,'Putz (Zement/Sand)','\\unit{1\\,800}{\\kilo\\gram\\per\\cubicmetre}',NULL,NULL,NULL,1.8000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1.0000,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('plaster_7',202,'',NULL,'Putz (Gips/Sand bzw. Kalk/Sand)',NULL,NULL,NULL,NULL,1.6000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.8000,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('plastic_1',202,'',NULL,'Kunststoff','',NULL,NULL,NULL,1.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.2000,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('ceramic',202,'',NULL,'Keramik/Porzellan',NULL,NULL,NULL,NULL,2.3000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1.3000,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('polyurethan_cat2',205,'',NULL,'Polyurethan-Hartschaum','DIN EN 13165, Kategorie II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0240,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('pheneol_cat2',205,'',NULL,'Phenolharz-Hartschaum','DIN EN 13166, Kategorie II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0240,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('foam_glas_cat2',205,'',NULL,'Schaumglas','DIN EN 13167, Kategorie II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0460,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('mineral_wool_cat2',205,'',NULL,'Mineralwolle','DIN EN 13162, Kategorie II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0360,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('wood_10_cat2',205,'',NULL,'Holzfaserdämmstoff','DIN EN 13171, Kategorie II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0430,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('cork_cat2',205,'',NULL,'Expandierter Kork','DIN EN 13170, Kategorie II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0490,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('tungsten',100,'','Tungsten','Wolfram','',NULL,3380.00,5660.00,19.2700,0.1340,NULL,NULL,192.60,4814.80,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,174.0000,4.5000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('magnesium',100,'','','Magnesium','',NULL,649.00,1090.00,1.7400,1.0470,NULL,NULL,372.60,5652.20,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,156.0000,26.0000,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('perlit_cat2',205,'',NULL,'Blähperlit','DIN EN 13169, Kategorie II',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0460,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `substances` VALUES ('petrol',110,'','','Benzin','',NULL,NULL,NULL,0.7800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1060.0000,NULL,42500,46700,NULL,NULL);
INSERT INTO `substances` VALUES ('diesel',110,'','','Diesel','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,41640,44800,NULL,NULL);
INSERT INTO `substances` VALUES ('methanol',110,'','','Methanol','',NULL,-98.00,64.50,0.7870,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1100.0000,NULL,21090,23840,NULL,NULL);
INSERT INTO `substances` VALUES ('petroleum',110,'','','Petroleum','',NULL,NULL,NULL,0.8100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,960.0000,NULL,40800,42900,NULL,NULL);
INSERT INTO `substances` VALUES ('methane',115,'',NULL,'Methan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35790,39850);
INSERT INTO `substances` VALUES ('propan',115,'',NULL,'Propan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,100890,92890);
INSERT INTO `substances` VALUES ('butene',115,'',NULL,'Butan',NULL,NULL,NULL,NULL,0.0027,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,123650,133870);
INSERT INTO `substances` VALUES ('aceton',110,'','','Aceton (Propanon)','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1430.0000,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `substances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `symbols`
--

DROP TABLE IF EXISTS `symbols`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `symbols` (
  `name` varchar(32) NOT NULL DEFAULT '',
  `field` varchar(8) NOT NULL,
  `unit` varchar(128) NOT NULL DEFAULT '',
  `si_symbol` varchar(64) NOT NULL DEFAULT '',
  `de` varchar(48) NOT NULL DEFAULT '',
  `de_long` varchar(255) NOT NULL DEFAULT '',
  `en` varchar(32) NOT NULL DEFAULT '',
  `en_long` varchar(255) NOT NULL DEFAULT '',
  `it` varchar(255) NOT NULL DEFAULT '',
  `it_long` varchar(255) NOT NULL DEFAULT '',
  `fr` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='symbols and their descriptions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `symbols`
--

LOCK TABLES `symbols` WRITE;
/*!40000 ALTER TABLE `symbols` DISABLE KEYS */;
INSERT INTO `symbols` VALUES ('t','RT','temperature_c','t','Temperatur','Temperatur (Celsiustemperatur)','Temperature','Temperature','Temperatura','','');
INSERT INTO `symbols` VALUES ('t_evap','RT','temperature_c','t_o','Verdampfungstemperatur','','Evaporation Temperature','','Temperatura di evaporatione','','');
INSERT INTO `symbols` VALUES ('length','RT','length','l','Länge','','length','','Lunghezza','','');
INSERT INTO `symbols` VALUES ('t_cond','RT','temperature_c','t_c','Verflüssigungstemperatur','','Condensation Temperature','','Temperatura di condensatione','','');
INSERT INTO `symbols` VALUES ('t_d','RT','t_delta','\\Delta T','Temperaturdifferenz','','','','','','');
INSERT INTO `symbols` VALUES ('density','RT','density','\\varrho','Dichte','Dichte','Density','Density','Densitá','','Geraten');
INSERT INTO `symbols` VALUES ('mass','RT','mass','m','Masse','Masse','Mass','Mass','Massa','','');
INSERT INTO `symbols` VALUES ('volume','RT','volume','V','Volumen','','Volume','','Volume','','');
INSERT INTO `symbols` VALUES ('volume_room','RT','volume','V_{Raum}','Raumvolumen','','Volume of the Room','','','','');
INSERT INTO `symbols` VALUES ('p_abs','RT','pressure','p_{abs}','absoluter Druck','','Pressure (absolut)','','Pressione','','Fradueck');
INSERT INTO `symbols` VALUES ('v_gas','RT','spec_volume','v\'\'','spezifisches Volumen','spezifisches Volumen (Sattdampf)','','','','','');
INSERT INTO `symbols` VALUES ('v_liquid','RT','spec_volume','v\'','spezifisches Volumen','spezifisches Volumen (siedende Flüssigkeit)','','','','','');
INSERT INTO `symbols` VALUES ('h_gas','RT','spec_energy','h\'\'','spezifische Enthalpie','spezifische Enthalpie (Sattdampf)','','','','','');
INSERT INTO `symbols` VALUES ('h_liquid','RT','spec_energy','h\'','spezifische Enthalpie','spezifische Enthalpie (siedende Flüssigkeit)','','','','','');
INSERT INTO `symbols` VALUES ('area','RT','area','A','Fläche','','Area','','Zona','','');
INSERT INTO `symbols` VALUES ('heat_capacity','RT','heat_capacity','c','spezifische Wärmekapazität','','heat capacity','','Capacitá termica','','');
INSERT INTO `symbols` VALUES ('energy','RT','energy','E','Energie','','Energy','','Energia','','');
INSERT INTO `symbols` VALUES ('force','RT','force','F','Kraft','','Force','','Forza','','');
INSERT INTO `symbols` VALUES ('accel_grav','RT','acceleration','g','Fallbeschleunigung','Fallbeschleunigung (Erdbeschleunigung)','acceleration of gravity','acceleration due to gravity','Acceleratione di gravitá','','');
INSERT INTO `symbols` VALUES ('enthalpie','RT','energy','H','Enthalpie','','Enthalpy','','Entalpia','','');
INSERT INTO `symbols` VALUES ('spec_enthalpy','RT','spec_energy','h','spezifische Enthalpie','','specific enthalpy','','Entalpia specifica','','');
INSERT INTO `symbols` VALUES ('mass_flow','RT','mass_flow','\\dot{m}','Massenstrom','','Mass flow','','Portata di peso','','');
INSERT INTO `symbols` VALUES ('power','RT','power','P','Leistung','','Power','','Alimentazione','','');
INSERT INTO `symbols` VALUES ('p_e','RT','pressure','p_{e}','Überdruck','','Positiv pressure','','','','');
INSERT INTO `symbols` VALUES ('p_amb','RT','pressure','p_{amb}','Umgebungsdruck','','ambient pressure','','Pressione ambiente','','');
INSERT INTO `symbols` VALUES ('p_c','RT','pressure','p_{c}','Verflüssigungsdruck','','Liquefaction pressure','','Pressione di liquefazione','','');
INSERT INTO `symbols` VALUES ('p_evap','RT','pressure','p_{o}','Verdampfungsdruck','','Evaporation pressure','','Pressione di evaporazione','','');
INSERT INTO `symbols` VALUES ('heat','RT','energy','Q','Wärmemenge','Wärmemenge, Wärme','Heat','','calore','','');
INSERT INTO `symbols` VALUES ('heat_power','RT','power','\\dot{Q}','Wärmestrom','','Heat flow','','Flusso di calore','','');
INSERT INTO `symbols` VALUES ('heat_power_c','RT','power','\\dot{Q}_c','Verflüssigerleistung','','','','','','');
INSERT INTO `symbols` VALUES ('heat_power_evap','RT','power','\\dot{Q}_o','Verdampferleistung','','','','','','');
INSERT INTO `symbols` VALUES ('spec_heat','RT','spec_energy','q','spezifische Verdampfungswärme','','','','','','');
INSERT INTO `symbols` VALUES ('spec_heat_c','RT','spec_energy','q_{c}','spezifische Verflüssigerwärme','','','','','','');
INSERT INTO `symbols` VALUES ('spec_heat_evap','RT','spec_energy','q_{o}','spezifische Verdampferwärme','','','','','','');
INSERT INTO `symbols` VALUES ('entropy','RT','entropy','S','Entropie','','Entropy','','','','');
INSERT INTO `symbols` VALUES ('spec_entropy','RT','spec_entropy','s','spezifische Entropie','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_blind_capacitance','ET','voltage','U_{bC}','Kapazitive Blindspannung','','','','','','');
INSERT INTO `symbols` VALUES ('volume_flow','RT','volume_flow','\\dot{V}','Volumenstrom','','','','','','');
INSERT INTO `symbols` VALUES ('heat_transfer_coefficient','RT','heat_transfer','\\alpha','Wärmeübergangskoeffizient','','Heat transfer coefficient','','','','');
INSERT INTO `symbols` VALUES ('heat_conductivity','RT','heat_conductivity','\\lambda','Wärmeleitkoeffizient','','Heat conductivity coefficient','','','','');
INSERT INTO `symbols` VALUES ('heat_transmission_coefficient','RT','heat_transfer','U','Wärmedurchgangskoeff.','Wärmedurchgangskoeffizient (früher k-Wert)','','','','','');
INSERT INTO `symbols` VALUES ('heat_flux_density','RT','heat_flux_density','q','Wärmestromdichte','','Heat flux density','','','','');
INSERT INTO `symbols` VALUES ('amperage','RT','amperage','I','Stromstärke','','','','','','');
INSERT INTO `symbols` VALUES ('efficiency','RT','no_unit','\\eta','Wirkungsgrad','','','','','','');
INSERT INTO `symbols` VALUES ('absolute_humidity','RT','absolute_humidity','x','Wassergehalt','Wassergehalt (absolute Luftfeuchte), Wasserdampf je Kilogramm trockene Luft','','','','','');
INSERT INTO `symbols` VALUES ('absolute_humidity_saturation','RT','absolute_humidity','x_{s}','Wassergehalt (gesättigt)','Wassergehalt im Sättigungszustand','','','','','');
INSERT INTO `symbols` VALUES ('volume_expansion','RT','thermal_expansion','\\gamma','Volumenausdehnungskoeffizient','(thermischer) Volumenausdehnungskoeffizient','','','','','');
INSERT INTO `symbols` VALUES ('length_expansion','RT','thermal_expansion','\\alpha_{l}','Längenausdehnungskoeffizient','(thermischer) Längenausdehnungskoeffizient','','','','','');
INSERT INTO `symbols` VALUES ('log_temperature','RT','t_delta','\\Delta T_{m}','mittlere logarithmische Temperaturdifferenz','','','','','','');
INSERT INTO `symbols` VALUES ('spec_volume','RT','spec_volume','v','spezifisches Volumen','','','','','','');
INSERT INTO `symbols` VALUES ('force_g','RT','force','F_{G}','Gewichtskraft','','','','','','');
INSERT INTO `symbols` VALUES ('length_s','RT','length','s','Weg in Kraftrichtung','','','','','','');
INSERT INTO `symbols` VALUES ('time','RT','time','\\tau','Zeit','Zeit (Kältetechnik)','','','','','');
INSERT INTO `symbols` VALUES ('heat_value_gas','RT','spec_energy_vol','H_{u,n}','spezifischer Heizwert (Brenngase)','','','','','','');
INSERT INTO `symbols` VALUES ('enthalpy_melt','RT','spec_energy','\\Delta h_{f}','spezifische Schmelzenthalpie','','','','','','');
INSERT INTO `symbols` VALUES ('relative_humidity','RT','no_unit','\\varphi','relative Feuchte','relative Feuchte der Luft','','','','','');
INSERT INTO `symbols` VALUES ('qualiti_grade','RT','no_unit','\\eta','Gütegrad','','','','','','');
INSERT INTO `symbols` VALUES ('coefficient_of_performance','RT','no_unit','\\varepsilon','Leistungszahl','','Coefficient of performance','','','','');
INSERT INTO `symbols` VALUES ('glide','RT','temperature_k','\\Delta T_{glide}','Temperaturgleit','','','','','','');
INSERT INTO `symbols` VALUES ('t_crit','RT','temperature_c','t_{crit}','Kritische Temperatur','','','','','','');
INSERT INTO `symbols` VALUES ('heat_capacity_gas_p','RT','heat_capacity','c_{p}','spezifische Wärmekapazität (Gas)','spezifische Wärmekapazität Gas ($p=const.$)','','','','','');
INSERT INTO `symbols` VALUES ('heat_capacity_solid','RT','heat_capacity','c_{solid}','spezifische Wärmekapazität (Festkörper)','','','','','','');
INSERT INTO `symbols` VALUES ('heat_capacity_liquid','RT','heat_capacity','c_{liquid}','spezifische Wärmekapazität (Flüssigkeit)','','','','','','');
INSERT INTO `symbols` VALUES ('t_melt','RT','temperature_c','t_{s}','Schmelztemperatur','Schmelz-/Erstarrungstemperatur','','','','','');
INSERT INTO `symbols` VALUES ('heat_capacity_gas_v','RT','heat_capacity','c_{v}','spezifische Wärmekapazität (Gas)','spezifische Wärmekapazität Gas ($v=const.$)','','','','','');
INSERT INTO `symbols` VALUES ('spec_heat_breathe','RT','spec_heat_flow','\\dot{q}_{A}','spezifischer Atmungswärmestrom','','','','','','');
INSERT INTO `symbols` VALUES ('velocity','RT','velocity','w','Geschwindigkeit','','Velocity','','','','');
INSERT INTO `symbols` VALUES ('power_out','RT','power','P_{ab}','abgegebene Leistung (Nutzen)','abgegebene Leistung (Nutzen)','','','','','');
INSERT INTO `symbols` VALUES ('power_in','RT','power','P_{zu}','zugeführte Leistung (Aufwand)','aufgenommene Leistung (Aufwand)','','','','','');
INSERT INTO `symbols` VALUES ('length_sw','RT','length','s','Weg','','','','','','');
INSERT INTO `symbols` VALUES ('density_in','RT','density','\\varrho_{1}','Dichte 1','','','','','','');
INSERT INTO `symbols` VALUES ('density_out','RT','density','\\varrho_{2}','Dichte 2','','','','','','');
INSERT INTO `symbols` VALUES ('area_in','RT','area','A_{1}','Rohrquerschnitt 1','','','','','','');
INSERT INTO `symbols` VALUES ('area_out','RT','area','A_{2}','Rohrquerschnitt 2','','','','','','');
INSERT INTO `symbols` VALUES ('velocity_in','RT','velocity','w_{1}','Strömungsgeschwindigkeit 1','','','','','','');
INSERT INTO `symbols` VALUES ('velocity_out','RT','velocity','w_{2}','Strömungsgeschwindigkeit 2','','','','','','');
INSERT INTO `symbols` VALUES ('pressure','RT','pressure','p','Druck','','','','','','');
INSERT INTO `symbols` VALUES ('height','RT','length','h','Höhe','','','','','','');
INSERT INTO `symbols` VALUES ('pressure_drop','RT','pressure','\\Delta p','Gesamt-Druckverlust','','','','','','');
INSERT INTO `symbols` VALUES ('tube_friction','RT','no_unit','\\lambda','Rohrreibungszahl','','','','','','');
INSERT INTO `symbols` VALUES ('diameter','RT','length','d','Durchmesser','','','','','','');
INSERT INTO `symbols` VALUES ('length_equiv','RT','length','l\'','äquivalente Rohrlänge','','','','','','');
INSERT INTO `symbols` VALUES ('pressure_drop_flow','RT','pressure','\\Delta p_{1}','Druckverlust durch Strömung','','','','','','');
INSERT INTO `symbols` VALUES ('pressure_drop_vert','RT','pressure','\\Delta p_{2}','Druckverlust durch Höhenunterschied','','','','','','');
INSERT INTO `symbols` VALUES ('height_delta','RT','length','\\Delta h','Höhenunterschied (Vorzeichen beachten)','Höhenunterschied bei hyrostatischen Druck, $+$ nach oben (Druckverlust), $-$ nach unten (Druckgewinn)','','','','','');
INSERT INTO `symbols` VALUES ('temperature_k','RT','temperature_k','T','thermodynamische (absolute) Temperatur','','','','','','');
INSERT INTO `symbols` VALUES ('temperature_f','RT','temperature_f','t_{F}','Temperatur (Fahrenheittemperatur)','Temperatur in Fahrenheit','','','','','');
INSERT INTO `symbols` VALUES ('length_delta','RT','length','\\Delta l','Längenänderung','Längenänderung, Längendifferenz','','','','','');
INSERT INTO `symbols` VALUES ('volume_delta','RT','volume','\\Delta V','Volumenänderung','','','','','','');
INSERT INTO `symbols` VALUES ('pressure_in','RT','pressure','p_{1}','absoluter Druck im Zustand 1','','','','','','');
INSERT INTO `symbols` VALUES ('pressure_out','RT','pressure','p_{2}','absoluter Druck im Zustand 2','','','','','','');
INSERT INTO `symbols` VALUES ('volume_in','RT','volume','V_{1}','Volumen im Zustand 1','','','','','','');
INSERT INTO `symbols` VALUES ('volume_out','RT','volume','V_{2}','Volumen im Zustand 2','','','','','','');
INSERT INTO `symbols` VALUES ('temperature_in','RT','temperature_k','T_{1}','Temperatur im Zustand 1','','','','','','');
INSERT INTO `symbols` VALUES ('temperature_out','RT','temperature_k','T_{2}','Temperatur im Zustand 2','','','','','','');
INSERT INTO `symbols` VALUES ('heat_in','RT','energy','Q_{auf}','aufgenommene Wärmemenge','','','','','','');
INSERT INTO `symbols` VALUES ('t_d_in','RT','t_delta','\\Delta T_{1}','Temperaturdifferenz vor dem Erstarren','','','','','','');
INSERT INTO `symbols` VALUES ('t_d_out','RT','t_delta','\\Delta T_{2}','Temperaturdifferenz nach dem Erstarren','','','','','','');
INSERT INTO `symbols` VALUES ('heat_out','RT','energy','Q_{ab}','abgegebene Wärmemenge','','','','','','');
INSERT INTO `symbols` VALUES ('absolute_humidity_delta','RT','absolute_humidity','\\Delta x','spezifische Feuchteänderung','','','','','','');
INSERT INTO `symbols` VALUES ('absolute_humidity_one','RT','absolute_humidity','x_{1}','Wassergehalt im Zustand 1','','','','','','');
INSERT INTO `symbols` VALUES ('absolute_humidity_two','RT','absolute_humidity','x_{2}','Wassergehalt im Zustand 2','','','','','','');
INSERT INTO `symbols` VALUES ('power_need','RT','power','\\dot{Q}','Kältebedarf','','','','','','');
INSERT INTO `symbols` VALUES ('power_cool','RT','power','\\dot{Q}_K','Kühlgutwärmestrom','','','','','','');
INSERT INTO `symbols` VALUES ('power_heatflow','RT','power','\\dot{Q}_T','Wärmestrom durch Transmission','Wärmestrom durch Wärmedurchgang (Transmission)','','','','','');
INSERT INTO `symbols` VALUES ('power_airexchange','RT','power','\\dot{Q}_L','Wärmestrom durch Lufterneuerung','','','','','','');
INSERT INTO `symbols` VALUES ('power_light','RT','power','\\dot{Q}_B','Beleuchtungswärmestrom','','','','','','');
INSERT INTO `symbols` VALUES ('power_person','RT','power','\\dot{Q}_P','Personenwärmestrom','','','','','','');
INSERT INTO `symbols` VALUES ('power_defreeze','RT','power','\\dot{Q}_H','Abtauwärmestrom','','','','','','');
INSERT INTO `symbols` VALUES ('power_fan','RT','power','\\dot{Q}_V','Ventilatorwärmestrom','','','','','','');
INSERT INTO `symbols` VALUES ('power_el','RT','power','P_{el}','elektrische Leistungsaufnahme','','','','','','');
INSERT INTO `symbols` VALUES ('time_on','RT','time','\\tau','tägliche Einschaltzeit','','','','','','');
INSERT INTO `symbols` VALUES ('persons','RT','no_unit','n','Personenanzahl','','','','','','');
INSERT INTO `symbols` VALUES ('power_per_person','RT','power','q_{p}','Wärmestrom pro Person','Wärmestrom pro Person ($\\approx$ \\unit{230}{\\watt})','','','','','');
INSERT INTO `symbols` VALUES ('time_defreeze_on','RT','time','\\tau','tägliche Abtaudauer','','','','','','');
INSERT INTO `symbols` VALUES ('time_inside','RT','time','\\tau','tägliche Aufenthaltszeit','','','','','','');
INSERT INTO `symbols` VALUES ('time_run','RT','time','\\tau','tägliche Laufzeit','','','','','','');
INSERT INTO `symbols` VALUES ('mass_flow_refrigerant','RT','mass_flow','\\dot{m}_R','Massenstrom des Kältemittels','','','','','','');
INSERT INTO `symbols` VALUES ('mass_flow_cold','RT','mass_flow','\\dot{m}_K','Massenstrom des Kälteträgers','','','','','','');
INSERT INTO `symbols` VALUES ('mass_flow_heat','RT','mass_flow','\\dot{m}_W','Massenstrom des Wärmeträgers','','','','','','');
INSERT INTO `symbols` VALUES ('t_d_max','RT','t_delta','\\Delta T_{max}','Maximale Temperaturdifferenz','Maximale Temperaturdifferenz zwischen den Medien','','','','','');
INSERT INTO `symbols` VALUES ('t_d_min','RT','t_delta','\\Delta T_{min}','Minimale Temperaturdifferenz','Minimale Temperaturdifferenz zwischen den Medien','','','','','');
INSERT INTO `symbols` VALUES ('area_tube','RT','area','A_{R}','Rohroberfläche (außen)','','','','','','');
INSERT INTO `symbols` VALUES ('area_fin','RT','area','A_{L}','Lamellenoberfläche','','','','','','');
INSERT INTO `symbols` VALUES ('n_fin','RT','no_unit','n_{L}','Lamellenanzahl','','','','','','');
INSERT INTO `symbols` VALUES ('n_tube','RT','no_unit','n_{R}','Kernrohranzahl','','','','','','');
INSERT INTO `symbols` VALUES ('enthalpy_air','RT','spec_energy','\\Delta h','Enthalpiedifferenz zw. Luftzuständen','Enthalpiedifferenz zwischen zwei Luftzuständen','','','','','');
INSERT INTO `symbols` VALUES ('volume_flow_air','RT','volume_flow','\\dot{V}_{L}','Luftvolumenstrom','','','','','','');
INSERT INTO `symbols` VALUES ('efficiency_fan','RT','no_unit','\\eta_{L}','Gesamtwirkungsgrad des Lüfters','','','','','','');
INSERT INTO `symbols` VALUES ('pressure_drop_liquid','RT','pressure','\\Delta{p}_{F\\hspace{-0.24ex}L}','Druckverlust Flüssigkeitsleitung','Druckverlust in der Flüssigkeitsleitung','','','','','');
INSERT INTO `symbols` VALUES ('pressure_drop_h','RT','pressure','\\Delta{p}_{\\Delta h}','Druckabfall Höhenunterschied','Druckabfall durch Höhenunterschied','','','','','');
INSERT INTO `symbols` VALUES ('pressure_drop_fork','RT','pressure','\\Delta{p}_{FV}','Druckabfall durch Verteiler','','','','','','');
INSERT INTO `symbols` VALUES ('pressure_drop_e','RT','pressure','\\Delta{p}_{E}','Druckabfall am Drosselorgan','','','','','','');
INSERT INTO `symbols` VALUES ('displacement_volume','RT','volume','V_{g}','Hubvolumen','','','','','','');
INSERT INTO `symbols` VALUES ('displacement_length','RT','length','l_{H}','Hublänge','','','','','','');
INSERT INTO `symbols` VALUES ('cylinder_number','RT','no_unit','z','Zylinderanzahl','','','','','','');
INSERT INTO `symbols` VALUES ('air_change_rate','RT','frequency','n','Luftwechselrate','Luftwechselrate (Luftwechsel, Luftwechselzahl)','','','','','');
INSERT INTO `symbols` VALUES ('diameter_in','RT','length','d_{1}','Durchmesser treibende Scheibe','Durchmesser der treibenden Scheibe','','','','','');
INSERT INTO `symbols` VALUES ('displacement_volume_flow','RT','volume_flow','\\dot{V}_{g}','geometrischer Hubvolumenstrom','','','','','','');
INSERT INTO `symbols` VALUES ('rev_frequency','RT','frequency','n','Drehzahl','','','','','','');
INSERT INTO `symbols` VALUES ('spec_volume_suction','RT','spec_volume','v_{V1}','spezifisches Volumen am Verdichtungsbeginn','spezifisches Volumen am Verdichtungsbeginn','','','','','');
INSERT INTO `symbols` VALUES ('delivery','RT','no_unit','\\lambda','Liefergrad des Verdichters','','','','','','');
INSERT INTO `symbols` VALUES ('displacement_volume_flow_prac','RT','volume_flow','\\dot{V}_{V1}','praktischer Hubvolumenstrom','praktischer Hubvolumenstrom am Verdichtungsbeginn','','','','','');
INSERT INTO `symbols` VALUES ('diameter_out','RT','length','d_{2}','Durchmesser getriebene Scheibe','Durchmesser der getriebenen Scheibe','','','','','');
INSERT INTO `symbols` VALUES ('rev_frequency_in','RT','frequency','n_{1}','Drehzahl treibende Scheibe','Drehzahl der treibenden Scheibe','','','','','');
INSERT INTO `symbols` VALUES ('rev_frequency_out','RT','frequency','n_{2}','Drehzahl getriebene Scheibe','Drehzahl der getriebenen Scheibe','','','','','');
INSERT INTO `symbols` VALUES ('power_breathe','RT','power','\\dot{Q}_{A}','Atmungswärmestrom','','','','','','');
INSERT INTO `symbols` VALUES ('spec_work','RT','spec_energy','w','spezifische Verdichterarbeit','','','','','','');
INSERT INTO `symbols` VALUES ('t_evap_entry','RT','temperature_c','t_{o1}','Temperatur am Verdampfereintritt','','','','','','');
INSERT INTO `symbols` VALUES ('t_evap_end','RT','temperature_c','t_{o2}','Temperatur Verdampfungsende','Temperatur im Verdampfer am Ende der Verdampfung','','','','','');
INSERT INTO `symbols` VALUES ('t_evap_exit','RT','temperature_c','t_{o2h}','Temperatur am Verdampferausgang','Temperatur des überhitzten Kältemittels am Verdampferausgang','','','','','');
INSERT INTO `symbols` VALUES ('t_comp_entry','RT','temperature_c','t_{V1}','Temperatur am Verdichtungsbeginn','','','','','','');
INSERT INTO `symbols` VALUES ('t_comp_exit','RT','temperature_c','t_{V2}','Temp. Verdichtungsende','Temperatur am Verdichtungsende','','','','','');
INSERT INTO `symbols` VALUES ('h_cond_entry','RT','spec_energy','h_{c1h}','spez. Enthalpie Verflüssigereintritt','spezifische Enthalpie am Verflüssigereintritt','','','','','');
INSERT INTO `symbols` VALUES ('h_cond_exit','RT','spec_energy','h_{c2u}','spez. Enthalpie Verflüssigeraustritt','spezifische Enthalpie am Verflüssigeraustritt','','','','','');
INSERT INTO `symbols` VALUES ('t_cond_start','RT','temperature_c','t_{c1}','Temperatur Verflüssigungsbeginn','','','','','','');
INSERT INTO `symbols` VALUES ('t_cond_end','RT','temperature_c','t_{c2}','Temperatur Verflüssigungsende','','','','','','');
INSERT INTO `symbols` VALUES ('t_exp_entry','RT','temperature_c','t_{E1}','Temp. Expansionsventileintritt','Temperatur am  Expansionsventileintritt','','','','','');
INSERT INTO `symbols` VALUES ('t_exp_exit','RT','temperature_c','t_{E2}','Temp. Expansionsventilaustritt','Temperatur am Expansionsventilaustritt','','','','','');
INSERT INTO `symbols` VALUES ('thickness','RT','length','d','Dicke','','','','','','');
INSERT INTO `symbols` VALUES ('t_evap_abs','RT','temperature_k','T_{o}','Verdampfungstemperatur','','','','','','');
INSERT INTO `symbols` VALUES ('t_cond_abs','RT','temperature_k','T_{c}','Verflüssigungstemperatur','','','','','','');
INSERT INTO `symbols` VALUES ('cop_eff_cool','RT','no_unit','\\varepsilon_{K_{\\scriptstyle e}}','effektive Kälteleistungszahl','','','','','','');
INSERT INTO `symbols` VALUES ('cop_eff_heat','RT','no_unit','\\varepsilon_{W\\hspace{-0.2ex}P_{\\scriptstyle e}}','effektive Wärmeleistungszahl','','','','','','');
INSERT INTO `symbols` VALUES ('spec_work_ind','RT','spec_energy','w_{i}','spez. indizierte Verdichterarbeit','spezifische Verdichterarbeit bei praktischer (indizierter) Verdichtung','','','','','');
INSERT INTO `symbols` VALUES ('spec_work_is','RT','spec_energy','w_{is}','spez. isentrope Verdichterarbeit','spezifische Verdichterarbeit bei isentroper Verdichtung','','','','','');
INSERT INTO `symbols` VALUES ('spec_work_eff','RT','spec_energy','w_{e}','spez. effektive Verdichterarbeit','spezifische effektive Verdichterarbeit (an der Kurbelwelle)','','','','','');
INSERT INTO `symbols` VALUES ('guete_wp','RT','no_unit','\\eta_{W\\hspace{-0.2ex}P}','Gütegrad der Wärmepumpe','','','','','','');
INSERT INTO `symbols` VALUES ('h_evap_exit','RT','spec_energy','h_{o2h}','spez. Enthalpie Verdampferausgang','spezifische Enthalpie des überhitzten Kältemittels am Verdampferausgang','','','','','');
INSERT INTO `symbols` VALUES ('h_exp_exit','RT','spec_energy','h_{E2}','Enthalpie Expansionsventilaustritt','spezifische Enthalpie am Expansionsventilaustritt','','','','','');
INSERT INTO `symbols` VALUES ('volume_heat_evap','RT','volume_energy','q_{ov}','volumenstrombezogene Verdampferleistung','volumenstrombezogene Verdampferleistung (Volumetrischer Kältegewinn)','','','','','');
INSERT INTO `symbols` VALUES ('t_cond_entry','RT','temperature_c','t_{c1h}','Temperatur Verflüssigereintritt','Temperatur am Verflüssigereintritt','','','','','');
INSERT INTO `symbols` VALUES ('t_cond_exit','RT','temperature_c','t_{c2u}','Temperatur Verflüssigeraustritt','Temperatur am Verflüssigeraustritt','','','','','');
INSERT INTO `symbols` VALUES ('h_comp_exit','RT','spec_energy','h_{V2}','spez. Enthalpie am Verdichtungsende','','','','','','');
INSERT INTO `symbols` VALUES ('h_comp_entry','RT','spec_energy','h_{V1}','spez. Enthalpie am Verdichtungsbeginn','','','','','','');
INSERT INTO `symbols` VALUES ('h_comp_isentrop','RT','spec_energy','h_{2\'}','spez. Enthalpie nach isentroper Verdichtung','spezifische Enthalpie nach isentroper Verdichtung','','','','','');
INSERT INTO `symbols` VALUES ('power_el_mot','RT','power','P_{M}','Leistung Motorwelle','Leistung an der Motorwelle','','','','','');
INSERT INTO `symbols` VALUES ('power_el_kl','RT','power','P_{K\\hspace{-0.24ex}L}','Klemmenleistung Motor','','','','','','');
INSERT INTO `symbols` VALUES ('power_eff','RT','power','P_{e}','effektive Antriebsleistung','effektive Antriebsleistung (Wellenleistung an der Kurbelwelle)','','','','','');
INSERT INTO `symbols` VALUES ('power_ind','RT','power','P_{i}','indizierte Antriebsleistung','Antriebsleistung bei indizierter Verdichtung','','','','','');
INSERT INTO `symbols` VALUES ('power_is','RT','power','P_{is}','isentrope Antriebsleistung','Antriebsleistung bei isentroper Verdichtung','','','','','');
INSERT INTO `symbols` VALUES ('eta_el','RT','no_unit','\\eta_{el}','elektrischer Wirkungsgrad (Motor)','elektrischer Wirkungsgrad des Motors','','','','','');
INSERT INTO `symbols` VALUES ('eta_gear','RT','no_unit','\\eta_{\\text{ü}}','Wirkungsgrad der Übersetzung','','','','','','');
INSERT INTO `symbols` VALUES ('eta_mech','RT','no_unit','\\eta_{m}','mechanischer Wirkungsgrad','','','','','','');
INSERT INTO `symbols` VALUES ('eta_ind','RT','no_unit','\\eta_{i}','indizierter Wirkungsgrad','','','','','','');
INSERT INTO `symbols` VALUES ('eta_e','RT','no_unit','\\eta_{e}','effektiver Wirkungsgrad','','','','','','');
INSERT INTO `symbols` VALUES ('heat_power_comp','RT','power','\\dot{Q}_{oV}','Verdichterkälteleistung','','','','','','');
INSERT INTO `symbols` VALUES ('heat_transfer_coefficient_i','RT','heat_transfer','\\alpha_{i}','Wärmeübergangskoeff. innen','Wärmeübergangskoeffizient an der Wandinnenseite','Heat transfer coefficient inside','','','','');
INSERT INTO `symbols` VALUES ('heat_transfer_coefficient_a','RT','heat_transfer','\\alpha_{a}','Wärmeübergangskoeff. außen','Wärmeübergangskoeffizient an der Wandaußenseite','Heat transfer coefficient ouside','','','','');
INSERT INTO `symbols` VALUES ('area_wall','RT','area','A','Wandfläche','','','','','','');
INSERT INTO `symbols` VALUES ('heat_conductivity_one','RT','heat_conductivity','\\lambda_{1}','Wärmeleitkoeffizient Schicht 1','Wärmeleitkoeffizient der Schicht 1','','','','','');
INSERT INTO `symbols` VALUES ('heat_conductivity_two','RT','heat_conductivity','\\lambda_{2}','Wärmeleitkoeffizient Schicht 2','Wärmeleitkoeffizient der Schicht 2','','','','','');
INSERT INTO `symbols` VALUES ('thickness_one','RT','length','d_{1}','Wanddicke der Schicht 1','','','','','','');
INSERT INTO `symbols` VALUES ('thickness_two','RT','length','d_{2}','Wanddicke der Schicht 2','','','','','','');
INSERT INTO `symbols` VALUES ('t_oo_a','RT','temperature_c','t_{a,\\infty}','Temp. in großer Wandentfernung','Temperatur in großer Entfernung der Wandaußenseite','','','','','');
INSERT INTO `symbols` VALUES ('t_oo_i','RT','temperature_c','t_{i,\\infty}','Temp. in großer Wandentfernung','Temperatur in großer Entfernung der Wandinnenseite','','','','','');
INSERT INTO `symbols` VALUES ('t_one','RT','temperature_c','t_{1}','Temperatur an der Stelle 1','','','','','','');
INSERT INTO `symbols` VALUES ('t_two','RT','temperature_c','t_{2}','Temperatur an der Stelle 2','','','','','','');
INSERT INTO `symbols` VALUES ('t_three','RT','temperature_c','t_{3}','Temperatur an der Stelle 3','','','','','','');
INSERT INTO `symbols` VALUES ('heat_cool','RT','energy','Q_{K}','zu entziehende Wärmemenge','Wärmemenge, die dem Kühlgut entzogen werden muss','','','','','');
INSERT INTO `symbols` VALUES ('t_mix','RT','temperature_c','t_{m}','Mischungstemperatur','','','','','','');
INSERT INTO `symbols` VALUES ('mass_warm','RT','mass','m_{2}','Masse Stoff 2','','','','','','');
INSERT INTO `symbols` VALUES ('t_cold','RT','temperature_c','t_{1}','Temperatur Stoff 1','','','','','','');
INSERT INTO `symbols` VALUES ('t_warm','RT','temperature_c','t_{2}','Temperatur Stoff 2','','','','','','');
INSERT INTO `symbols` VALUES ('mass_cold','RT','mass','m_{1}','Masse Stoff 1','','','','','','');
INSERT INTO `symbols` VALUES ('heat_capacity_cold','RT','heat_capacity','c_{1}','spez. Wärmekapazität Stoff 1','spezifische Wärmekapazität (Stoff 1)','','','','','');
INSERT INTO `symbols` VALUES ('heat_capacity_warm','RT','heat_capacity','c_{2}','spez. Wärmekapazität Stoff 2','spezifische Wärmekapazität (Stoff 2)','','','','','');
INSERT INTO `symbols` VALUES ('p_sealevel','RT','pressure','p_{0}','Luftdruck in Meereshöhe','','','','','','');
INSERT INTO `symbols` VALUES ('density_sealevel','RT','density','\\varrho_{\\hspace{0.1ex}0}','Dichte in Meereshöhe','','','','','','');
INSERT INTO `symbols` VALUES ('height_nn','RT','length','h','Höhe über dem Meeresspiegel','','','','','','');
INSERT INTO `symbols` VALUES ('mass_flow_air','RT','mass_flow','\\dot{m}_L','Massenstrom der Luft','','','','','','');
INSERT INTO `symbols` VALUES ('power_radiation','RT','power','\\dot{Q}_S','Strahlungsenergie','Gesamtstrahlungsenergie (Emission) eines grauen Strahlers','','','','','');
INSERT INTO `symbols` VALUES ('emission','RT','no_unit','\\varepsilon','Emissionsgrad','Emissionsgrad eines grauen Strahlers','','','','','');
INSERT INTO `symbols` VALUES ('emission_one','RT','no_unit','\\varepsilon_{1}','Emissionsgrad der Fläche 1','Emissionsgrad der Fläche 1 (grauen Strahler)','','','','','');
INSERT INTO `symbols` VALUES ('emission_two','RT','no_unit','\\varepsilon_{2}','Emissionsgrad der Fläche 2','Emissionsgrad der Fläche 2 (grauen Strahler)','','','','','');
INSERT INTO `symbols` VALUES ('radiation_const','RT','radiation_const','\\sigma','Strahlungskonstante','','','','','','');
INSERT INTO `symbols` VALUES ('power_radiation_one','RT','power','\\dot{Q}_{S_{1,2}}','Wärmestrom von 1 nach 2','Wärmestrom (Emission), der von der Fläche 1 an die Fläche 2 übertragen wird','','','','','');
INSERT INTO `symbols` VALUES ('area_one','RT','area','A_{1}','Fläche 1 (hohe Temperatur)','','','','','','');
INSERT INTO `symbols` VALUES ('area_two','RT','area','A_{2}','Fläche 2 (tiefe Temperatur)','','','','','','');
INSERT INTO `symbols` VALUES ('t_a_two','RT','temperature_k','T_{2}','Temperatur der Fläche 2','','','','','','');
INSERT INTO `symbols` VALUES ('t_a_one','RT','temperature_k','T_{1}','Temperatur der Fläche 1','','','','','','');
INSERT INTO `symbols` VALUES ('cop_carnot_heatpump','RT','no_unit','\\varepsilon_{W\\hspace{-0.2ex}P_{\\scriptstyle c}}','Wärmeleistungszahl nach Carnot','Leistungszahl des Carnot-Prozesses für eine Wärmepumpe','','','','','');
INSERT INTO `symbols` VALUES ('cop_carnot_cooling','RT','no_unit','\\varepsilon_{K_{\\scriptstyle c}}','Kälteleistungszahl nach Carnot','Leistungszahl des Carnot-Prozesses einer Kältemaschine','','','','','');
INSERT INTO `symbols` VALUES ('tewi','RT','tewi','T\\hspace{-0.25ex}EW\\hspace{-0.37ex}I','gesamter Erderwärmungsbeitrag','gesamter, äquivalenter Erderwärmungsbeitrag','','','','','');
INSERT INTO `symbols` VALUES ('gwp','RT','gwp','GW\\hspace{-0.3ex}P','Treibhauspotential','','','','','','');
INSERT INTO `symbols` VALUES ('leakage','RT','leakage','L','Leckrate','','','','','','');
INSERT INTO `symbols` VALUES ('lifetime','RT','time','n','Betriebszeit der Anlage','','','','','','');
INSERT INTO `symbols` VALUES ('r_contents','RT','mass','m','Kältemittel-Füllmenge','','','','','','');
INSERT INTO `symbols` VALUES ('r_recycle','RT','no_unit','\\alpha_{R}','Kältemittel-Rückgewinnungsfaktor','','','','','','');
INSERT INTO `symbols` VALUES ('carbon_emission','RT','emission_per_energy','\\beta','$CO_2$-Emission','$CO_2$-Emission bezogen auf die erzeugte Energie','','','','','');
INSERT INTO `symbols` VALUES ('energy_year','RT','energy_year','E_a','Energieverbrauch im Jahr','','Energie','','Energia','','');
INSERT INTO `symbols` VALUES ('cop_cooling','RT','no_unit','CO\\hspace{-0.15ex}P_{K}','Coefficient of Performance','Coefficient of Performance (Kältemaschine)','','','','','');
INSERT INTO `symbols` VALUES ('cop_heatpump','RT','no_unit','CO\\hspace{-0.15ex}P_{W\\hspace{-0.2ex}P}','Coefficient of Performance','Coefficient of Performance (Wärmepumpe)','','','','','');
INSERT INTO `symbols` VALUES ('vapour_content','RT','no_unit','x','Dampfgehalt','Dampfgehalt, Kältemitteldampf je Kilogramm Kältemittel','','','','','');
INSERT INTO `symbols` VALUES ('pressure_diff','RT','pressure','\\Delta p','Druckdifferenz','','','','','','');
INSERT INTO `symbols` VALUES ('heat_value','RT','spec_energy','H_{u}','spezifischer Heizwert','spezifischer Heizwert (Alt: unterer Heizwert)','','','','','');
INSERT INTO `symbols` VALUES ('guete_cool','RT','no_unit','\\eta_{K}','Gütegrad der Kältemaschine','','','','','','');
INSERT INTO `symbols` VALUES ('work','RT','energy','W','Arbeit','','','','','','');
INSERT INTO `symbols` VALUES ('diameter_cyl','RT','length','d','Zylinderdurchmesser','','','','','','');
INSERT INTO `symbols` VALUES ('heat_value_upper','RT','spec_energy','H_{o}','spezifischer Brennwert','spezifischer Brennwert (Alt: oberer Heizwert)','','','','','');
INSERT INTO `symbols` VALUES ('heat_value_gas_upper','RT','spec_energy_vol','H_{o,n}','spezifischer Brennwert (Brenngase)','','','','','','');
INSERT INTO `symbols` VALUES ('enthalpy_evap','RT','spec_energy','\\Delta h_{d}','spezifische Verdampfungsenthalpie','','','','','','');
INSERT INTO `symbols` VALUES ('energy_pot','RT','energy','E_{pot}','potentielle Energie (Lageenergie)','','','','','','');
INSERT INTO `symbols` VALUES ('energy_elast','RT','energy','E_{elast}','elastische Energie (Spannenergie)','','','','','','');
INSERT INTO `symbols` VALUES ('spring_const','RT','spring_const','D','Federkonstante','','','','','','');
INSERT INTO `symbols` VALUES ('energy_kin','RT','energy','E_{kin}','kinetische Energie (Bewegungsenergie)','','','','','','');
INSERT INTO `symbols` VALUES ('acceleration','RT','acceleration','a','Beschleunigung','','','','','','');
INSERT INTO `symbols` VALUES ('density_dry','RT','density','\\varrho_{dry}','Dichte der trockenen Luft','Dichte der trockenen Luft','Density of dry air','Density of dry air','Densitá','','Geraten');
INSERT INTO `symbols` VALUES ('density_saturation','RT','density','\\varrho_{s}','Dichte der gesättigten Luft','Dichte der gesättigten Luft','Density of saturated air','Density of saturated air','Densitá','','Geraten');
INSERT INTO `symbols` VALUES ('enthalpy_saturation','RT','spec_energy','h_{s}','Enthalpie im Sättigungszustand','','','','','','');
INSERT INTO `symbols` VALUES ('pressure_vapour_saturation','RT','pressure','p_{ds}','Dampfdruck der gesättigten Luft','','','','','','');
INSERT INTO `symbols` VALUES ('resistance','ET','resistance','R','elektrischer Widerstand','','Electric resistance','','','','');
INSERT INTO `symbols` VALUES ('conductance','ET','conductance','G','elektrischer Leitwert','','Electric conductance','','','','');
INSERT INTO `symbols` VALUES ('resistivity','ET','resistivity','\\varrho','spezifischer Widerstand','','Resistivity','','','','');
INSERT INTO `symbols` VALUES ('area_conductor','ET','area','A','Leiterquerschnitt','','Area of conductor','','','','');
INSERT INTO `symbols` VALUES ('conductivity','ET','conductivity','\\varkappa','elektrische Leitfähigkeit','','Electrical conductivity','','','','');
INSERT INTO `symbols` VALUES ('length_conductor','ET','length','l','Leiterlänge','','length of conductor','','','','');
INSERT INTO `symbols` VALUES ('voltage_sum','ET','voltage','U','Gesamtspannung','','','','','','');
INSERT INTO `symbols` VALUES ('voltage','ET','voltage','U','Spannung','','Voltage','','','','');
INSERT INTO `symbols` VALUES ('voltage_b','ET','voltage','U_{2}','Teilspannung 2','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_c','ET','voltage','U_{3}','Teilspannung 3','','','','','','');
INSERT INTO `symbols` VALUES ('amperage_a','ET','amperage','I_{1}','Stromstärke 1','','','','','','');
INSERT INTO `symbols` VALUES ('amperage_b','ET','amperage','I_{2}','Stromstärke 2','','','','','','');
INSERT INTO `symbols` VALUES ('amperage_c','ET','amperage','I_{3}','Stromstärke 3','','','','','','');
INSERT INTO `symbols` VALUES ('amperage_sum','ET','amperage','I','Gesamtstromstärke','','','','','','');
INSERT INTO `symbols` VALUES ('conductance_sum','ET','conductance','G','Gesamtleitwert','','','','','','');
INSERT INTO `symbols` VALUES ('conductance_a','ET','conductance','G_{1}','Einzelleitwert 1','','','','','','');
INSERT INTO `symbols` VALUES ('conductance_b','ET','conductance','G_{2}','Einzelleitwert 2','','','','','','');
INSERT INTO `symbols` VALUES ('conductance_c','ET','conductance','G_{3}','Einzelleitwert 3','','','','','','');
INSERT INTO `symbols` VALUES ('resistance_equivalent','ET','resistance','R','Ersatzwiderstand','','Equivalent electric  resistance','','','','');
INSERT INTO `symbols` VALUES ('resistance_a','ET','resistance','R_{1}','Einzelwiderstand 1','','','','','','');
INSERT INTO `symbols` VALUES ('resistance_b','ET','resistance','R_{2}','Einzelwiderstand 2','','','','','','');
INSERT INTO `symbols` VALUES ('resistance_c','ET','resistance','R_{3}','Einzelwiderstand 3','','','','','','');
INSERT INTO `symbols` VALUES ('frequency','ET','frequency','f','Frequenz','','Frequency','','','','');
INSERT INTO `symbols` VALUES ('time_periodic','ET','time','T','Periodendauer','','Periocic Time','','','','');
INSERT INTO `symbols` VALUES ('angular_frequency','ET','frequency','\\omega','Kreisfrequenz','','Angular frequency','','','','');
INSERT INTO `symbols` VALUES ('inductance','ET','inductance','L','Induktivität','','Inductance','','','','');
INSERT INTO `symbols` VALUES ('inductance_sum','ET','inductance','L','Gesamtinduktivität','','','','','','');
INSERT INTO `symbols` VALUES ('inductance_a','ET','inductance','L_{1}','Induktivität 1','','Inductance 1','','','','');
INSERT INTO `symbols` VALUES ('inductance_b','ET','inductance','L_{2}','Induktivität 2','','Inductance 2','','','','');
INSERT INTO `symbols` VALUES ('inductance_c','ET','inductance','L_{3}','Induktivität 3','','Inductance 3','','','','');
INSERT INTO `symbols` VALUES ('amperage_peak','ET','amperage','\\hat{I}','Scheitelwert der Stromstärke','','','','','','');
INSERT INTO `symbols` VALUES ('capacitance','ET','capacitance','C','Kapazität','','Capacitance','','','','');
INSERT INTO `symbols` VALUES ('capacitance_sum','ET','capacitance','C','Gesamtkapazität','','','','','','');
INSERT INTO `symbols` VALUES ('capacitance_a','ET','capacitance','C_{1}','Kapazität 1','','Capacitance 1','','','','');
INSERT INTO `symbols` VALUES ('capacitance_b','ET','capacitance','C_{2}','Kapazität 2','','Capacitance 2','','','','');
INSERT INTO `symbols` VALUES ('capacitance_c','ET','capacitance','C_{3}','Kapazität 3','','Capacitance 3','','','','');
INSERT INTO `symbols` VALUES ('capacitance_equivalent','ET','capacitance','C','Ersatzkapazität','','','','','','');
INSERT INTO `symbols` VALUES ('inductance_equivalent','ET','inductance','L','Ersatzinduktivität','','','','','','');
INSERT INTO `symbols` VALUES ('charge','ET','charge','Q','Ladung','','Charge','','','','');
INSERT INTO `symbols` VALUES ('dielectric_const','ET','dielectric_const','\\varepsilon_{0}','Elektrische Feldkonstante','','Dielectric constant','','','','');
INSERT INTO `symbols` VALUES ('permittivity','ET','no_unit','\\varepsilon_{r}','Permittivität ','Permittivität (Dielektrizitätszahl, dieleketrische Leitfähigkeit)','Permittivity','','','','');
INSERT INTO `symbols` VALUES ('time_const','ET','time','\\tau','Zeitkonstante','','','','','','');
INSERT INTO `symbols` VALUES ('time_charge','ET','time','t','Aufladezeit','','','','','','');
INSERT INTO `symbols` VALUES ('reactance_inductive','ET','resistance','X_{L}','induktiver Blindwiderstand','induktiver Blindwiderstand (Induktive Reaktanz)','Inductive reactance','','','','');
INSERT INTO `symbols` VALUES ('reactance_capacity','ET','resistance','X_{C}','kapazitiver Blindwiderstand','kapazitiver Blindwiderstand (Kapazitive Reaktanz)','Capacity reactance','','','','');
INSERT INTO `symbols` VALUES ('amperage_effective','ET','amperage','I_{eff}','Effektivwert der Stromstärke','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_peak','ET','voltage','\\hat{U}','Scheitelwert der Spannung','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_effective','ET','voltage','U_{eff}','Effektivwert der Spannung','','','','','','');
INSERT INTO `symbols` VALUES ('impedance','ET','resistance','Z','Scheinwiderstand','','Impedance','','','','');
INSERT INTO `symbols` VALUES ('voltage_active','ET','voltage','U_{w}','Wirkspannung','','Active voltage','','','','');
INSERT INTO `symbols` VALUES ('voltage_blind_inductance','ET','voltage','U_{bL}','Induktive Blindspannung','','','','','','');
INSERT INTO `symbols` VALUES ('factor_power','ET','no_unit','cos\\,\\varphi','Wirkfaktor (Leistungsfaktor)','','','','','','');
INSERT INTO `symbols` VALUES ('factor_blind','ET','no_unit','sin\\,\\varphi','Blindfaktor','','','','','','');
INSERT INTO `symbols` VALUES ('resistance_active','ET','resistance','R','Wirkwiderstand','','Active resistance','','','','');
INSERT INTO `symbols` VALUES ('power_apparent','ET','power_apparent','S','Scheinleistung','Scheinleistung (el.)','Apparent Power','','','','');
INSERT INTO `symbols` VALUES ('power_active','ET','power','P','Wirkleistung','Wirkleistung (bei Wechselstrom)','','','','','');
INSERT INTO `symbols` VALUES ('power_reactive','ET','power_reactive','Q','Blindleistung','Blindleistung (el.)','','','','','');
INSERT INTO `symbols` VALUES ('impedance_in','ET','resistance','Z_{1}','Eingangsimpedanz','','','','','','');
INSERT INTO `symbols` VALUES ('impedance_out','ET','resistance','Z_{2}','Ausgangsimpedanz','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_a','ET','voltage','U_{1}','Teilspannung 1','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_in','ET','voltage','U_{1}','Spannung an der Eingangswicklung','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_out','ET','voltage','U_{2}','Spannung an der Ausgangswicklung','','','','','','');
INSERT INTO `symbols` VALUES ('winding_count_in','ET','no_unit','N_{1}','Windungszahl der Eingangswicklung','','','','','','');
INSERT INTO `symbols` VALUES ('winding_count_out','ET','no_unit','N_{2}','Windungszahl der Ausgangswicklung','','','','','','');
INSERT INTO `symbols` VALUES ('amperage_in','ET','amperage','I_{1}','Stromstärke in der Eingangswicklung','','','','','','');
INSERT INTO `symbols` VALUES ('amperage_out','ET','amperage','I_{2}','Stromstärke in der Ausgangswicklung','','','','','','');
INSERT INTO `symbols` VALUES ('transformation_ratio','ET','no_unit','\\ddot{u}','Übersetzungsverhältnis (Transformator)','','','','','','');
INSERT INTO `symbols` VALUES ('power_copper_loss','ET','power','P_{Cu}','Kupferverluste','','','','','','');
INSERT INTO `symbols` VALUES ('power_ferrum_loss','ET','power','P_{Fe}','Eisenverluste','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_short','ET','voltage','U_{k}','Kurzschlussspannung','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_short_percent','ET','percent','u_{k}','Kurzschlussspannung','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_nominal_in','ET','voltage','U_{1N}','Nennspannung an der Eingangswicklung','','','','','','');
INSERT INTO `symbols` VALUES ('amperage_nominal_in','ET','amperage','I_{1N}','Nennstromstärke in der Eingangswicklung','','','','','','');
INSERT INTO `symbols` VALUES ('amperage_short_in','ET','amperage','I_{1k}','Kurzschlußstromstärke in der Eingangswicklung','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_external_conductor','ET','voltage','U','Außenleiterspannung','','Voltage external conductor','','','','');
INSERT INTO `symbols` VALUES ('amperage_external_conductor','ET','amperage','I','Außenleiterstromstärke','','','','','','');
INSERT INTO `symbols` VALUES ('amperage_line','ET','amperage','I_{Str}','Strangstromstärke','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_line','ET','voltage','U_{Str}','Strangspannung','','','','','','');
INSERT INTO `symbols` VALUES ('power_line','ET','power','P_{Str}','Wirkleistung in einem Strang','','','','','','');
INSERT INTO `symbols` VALUES ('torque','ET','torque','M','Drehmoment','','Torque','','','','');
INSERT INTO `symbols` VALUES ('power_reactive_capacity','ET','power_reactive','Q_{C}','Blindleistung der Kondensatorbatterie','','','','','','');
INSERT INTO `symbols` VALUES ('phase_shift_before','ET','angle','\\varphi_{1}','Phasenverschiebungswinkel vor der Kompensation','','','','','','');
INSERT INTO `symbols` VALUES ('phase_shift_after','ET','angle','\\varphi_{2}','Phasenverschiebungswinkel nach der Kompensation','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_capacitor','ET','voltage','U_{C}','Spannung am Kondensator','','','','','','');
INSERT INTO `symbols` VALUES ('capacitance_line','ET','capacitance','C_{Str}','Strangkapazität','','','','','','');
INSERT INTO `symbols` VALUES ('amperage_before','ET','amperage','I_{1}','Stromstärke vor der Kompensation','','','','','','');
INSERT INTO `symbols` VALUES ('amperage_after','ET','amperage','I_{2}','Stromstärke nach der Kompensation','','','','','','');
INSERT INTO `symbols` VALUES ('slip','ET','percent','s','Schlupf','','slip','','','','');
INSERT INTO `symbols` VALUES ('rev_frequency_field','ET','frequency','n_{d}','Drehfelddrehzahl','','','','','','');
INSERT INTO `symbols` VALUES ('poles','ET','no_unit','p','Polpaarzahl','','','','','','');
INSERT INTO `symbols` VALUES ('temperature_compensation_slope','ET','temperature_compensation_slope','\\alpha','Temperaturbeiwert (el.)','','Temperature compensation slope','','','','');
INSERT INTO `symbols` VALUES ('resistance_at_temp','ET','resistance','R_{t}','elektrischer Widerstand bei der Temperatur $t$','','','','','','');
INSERT INTO `symbols` VALUES ('resistance_twenty','ET','resistance','R_{20}','elektrischer Widerstand bei \\unit{20}{\\celsius}','','','','','','');
INSERT INTO `symbols` VALUES ('power_dc','ET','power','P','Leistung','Leistung (bei Gleichstrom)','','','','','');
INSERT INTO `symbols` VALUES ('time_el','ET','time','t','Zeit','Zeit (Elektrotechnik)','','','','','');
INSERT INTO `symbols` VALUES ('s_liquid','RT','spec_entropy','s\'','spezifische Entropie','spezifische Entropie (siedende Flüssigkeit)','','','','','');
INSERT INTO `symbols` VALUES ('s_gas','RT','spec_entropy','s\'\'','spezifische Entropie','spezifische Entropie (Sattdampf)','','','','','');
INSERT INTO `symbols` VALUES ('dead_space_ratio','RT','no_unit','\\sigma','Schadraumverhältnis','Schadraumverhältnis','Dead Space Ratio','Dead Space Ratio','','','');
INSERT INTO `symbols` VALUES ('spec_enthalpy_cold','RT','spec_energy','h_{1}','spezifische Enthalpie (kalte Luft)','','specific enthalpy (cold air)','','','','');
INSERT INTO `symbols` VALUES ('absolute_humidity_mix','RT','absolute_humidity','x_{M}','Wassergehalt der Mischluft','','','','','','');
INSERT INTO `symbols` VALUES ('spec_enthalpy_mix','RT','spec_energy','h_{M}','spezifische Enthalpie der Mischluft','','specific enthalpy of mixed air','','','','');
INSERT INTO `symbols` VALUES ('spec_enthalpy_warm','RT','spec_energy','h_{2}','spezifische Enthalpie (warme Luft)','','specific enthalpy (warm air)','','','','');
INSERT INTO `symbols` VALUES ('volume_base','RT','volume','V_{o}','Ausgangsvolumen','','Volume','','Volume','','');
INSERT INTO `symbols` VALUES ('resistance_line','ET','resistance','R_{Str}','Strang Widerstand','','Line resistance','','','','');
INSERT INTO `symbols` VALUES ('length_base','RT','length','l_{o}','Ausgangslänge','','length','','Lunghezza','','');
INSERT INTO `symbols` VALUES ('resistance_n','ET','resistance','R_{n}','Einzelwiderstand n','','','','','','');
INSERT INTO `symbols` VALUES ('capacitance_n','ET','capacitance','C_{n}','Kapazität n','','Capacitance n','','','','');
INSERT INTO `symbols` VALUES ('inductance_n','ET','inductance','L_{n}','Induktivität n','','Inductance n','','','','');
INSERT INTO `symbols` VALUES ('amperage_n','ET','amperage','I_{n}','Stromstärke n','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_n','ET','voltage','U_{n}','Teilspannung n','','','','','','');
INSERT INTO `symbols` VALUES ('expense','ET','money','K','Kosten','','','','','','');
INSERT INTO `symbols` VALUES ('expense_per_work','ET','money_per_work','k','Arbeitspreis','','','','','','');
INSERT INTO `symbols` VALUES ('conductance_n','ET','conductance','G_{n}','Einzelleitwert n','','','','','','');
INSERT INTO `symbols` VALUES ('angle_bending','RT','angle','\\alpha','Biegewinkel','','Angle of Bending','','','','');
INSERT INTO `symbols` VALUES ('radius_bending','RT','length','r','Biegeradius','Biegeradius zur neutralen Faser','','','','','');
INSERT INTO `symbols` VALUES ('length_arc','RT','length','l_B','Bogenlänge','','','','','','');
INSERT INTO `symbols` VALUES ('mass_flow_water','RT','mass_flow','\\dot{m}_W','Massenstrom Wasser','','','','','','');
INSERT INTO `symbols` VALUES ('spec_volume_outlet','RT','spec_volume','v_{V2}','spezifisches Volumen am Verdichtungsende','spezifisches Volumen am Verdichtungsende','','','','','');
INSERT INTO `symbols` VALUES ('spec_volume_exp_entry','RT','spec_volume','v_{E1}','spezifisches Volumen am Expansionsventileintritt','spezifisches Volumen am Expansionsventileintritt','','','','','');
INSERT INTO `symbols` VALUES ('spec_volume_evap_outlet','RT','spec_volume','v_{o2h}','spezifisches Volumen am Verdampferausgang','spezifisches Volumen am Verdampferausgang','','','','','');
INSERT INTO `symbols` VALUES ('voltage_d','ET','voltage','U_{1}','Spannung am Leitungsanfang','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_e','ET','voltage','U_{2}','Spannung am Leitungsende','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_delta_u','ET','voltage','\\Delta U','Spannungsfall','','','','','','');
INSERT INTO `symbols` VALUES ('voltage_delta_u_percent','ET','voltage','\\Delta u','prozentualer Spannungsfall','','','','','','');
INSERT INTO `symbols` VALUES ('pressure_comp_in','RT','pressure','p_{V1}','Druck am Verdichtungsbeginn','','','','','','');
INSERT INTO `symbols` VALUES ('pressure_comp_out','RT','pressure','p_{V2}','Druck am Verdichtungsende','','','','','','');
INSERT INTO `symbols` VALUES ('enthalpy_diff','RT','spec_energy','\\Delta h','Enthalpiedifferenz zw. Zuständen','Enthalpiedifferenz zwischen zwei Zuständen','','','','','');
INSERT INTO `symbols` VALUES ('pressure_increase_total','RT','pressure','\\Delta p_{t}','Totaldruckerhöhung','','','','','','');
INSERT INTO `symbols` VALUES ('work_el','RT','energy','W_{el}','elektrische Arbeit','','','','','','');
INSERT INTO `symbols` VALUES ('volume_flow_1','RT','volume_flow','\\dot{V}_{1}','Volumenstrom 1','','','','','','');
INSERT INTO `symbols` VALUES ('volume_flow_2','RT','volume_flow','\\dot{V}_{2}','Volumenstrom 2','','','','','','');
INSERT INTO `symbols` VALUES ('rev_frequency_1','RT','frequency','n_{1}','Drehzahl 1','','','','','','');
INSERT INTO `symbols` VALUES ('rev_frequency_2','RT','frequency','n_{2}','Drehzahl 2','','','','','','');
INSERT INTO `symbols` VALUES ('pressure_drop_1','RT','pressure','\\Delta p_{1}','Druckverlust 1','','','','','','');
INSERT INTO `symbols` VALUES ('pressure_drop_2','RT','pressure','\\Delta p_{2}','Druckverlust 2','','','','','','');
INSERT INTO `symbols` VALUES ('power_1','ET','power','P_{1}','Leistung 1','','','','','','');
INSERT INTO `symbols` VALUES ('power_2','ET','power','P_{2}','Leistung 2','','','','','','');
INSERT INTO `symbols` VALUES ('power_loss','ET','power','P_{v}','Verlustleistung','','','','','','');
INSERT INTO `symbols` VALUES ('t_d_layer1','RT','t_delta','\\Delta T_{1}','Temperaturdifferenz Schicht 1','','','','','','');
INSERT INTO `symbols` VALUES ('t_d_layer2','RT','t_delta','\\Delta T_{2}','Temperaturdifferenz Schicht 2','','','','','','');
INSERT INTO `symbols` VALUES ('t_d_outside','RT','t_delta','\\Delta T_{a}','Temperaturdifferenz Außenseite','','','','','','');
INSERT INTO `symbols` VALUES ('t_d_inside','RT','t_delta','\\Delta T_{i}','Temperaturdifferenz Innenseite','','','','','','');
/*!40000 ALTER TABLE `symbols` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `units`
--

DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `units` (
  `unit` varchar(128) NOT NULL DEFAULT '',
  `latex_0` varchar(255) DEFAULT NULL,
  `latex_1` varchar(255) DEFAULT NULL,
  `latex_2` varchar(255) DEFAULT NULL,
  `latex_3` varchar(255) DEFAULT NULL,
  `latex_4` varchar(255) DEFAULT NULL,
  `latex_5` varchar(255) DEFAULT NULL,
  `latex_6` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`unit`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Latex representations of units';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `units`
--

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES ('temperature','\\celsius','\\kelvin','\\ensuremath{^\\circ}F',NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('length','\\metre','\\deci\\metre','\\centi\\metre',NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('mass','\\kilo\\gram','\\gram',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('volume','\\cubicmetre','\\deci\\cubicmetre','\\centi\\cubicmetre',NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('density','\\kilo\\gram\\per\\cubicmetre','\\kilo\\gram\\per\\deci\\cubicmetre',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('pressure','\\pascal','\\bbar','\\milli\\bbar',NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('spec_energy','\\joule\\per\\kilo\\gram','\\kilo\\joule\\per\\kilo\\gram',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('spec_volume','\\cubicmetre\\per\\kilo\\gram','\\deci\\cubicmetre\\per\\kilo\\gram',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('energy','\\joule','\\kilo\\joule','\\newton\\metre','\\kilo\\watt\\hour',NULL,NULL,NULL);
INSERT INTO `units` VALUES ('power','\\watt','\\kilo\\watt','\\kilo\\joule\\per\\second',NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('force','\\newton','\\kilo\\newton',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('area','\\squaremetre','\\milli\\squaremetre',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('time','\\second','\\hour','\\mathrm{a}',NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('heat_capacity','\\kilo\\joule\\per\\kilo\\gram\\usk\\kelvin','',NULL,NULL,NULL,'\\kilo\\joule\\per\\kilo\\gram\\kelvin',NULL);
INSERT INTO `units` VALUES ('acceleration','\\metre\\per\\square\\second',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('frequency','1\\per\\second','1\\per\\minute','\\hertz','1\\per\\hour',NULL,NULL,NULL);
INSERT INTO `units` VALUES ('entropy','\\joule\\per\\kelvin',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('spec_entropy','\\joule\\per\\kilo\\gram\\usk\\kelvin','\\kilo\\joule\\per\\kilo\\gram\\usk\\kelvin',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('voltage','\\volt','\\kilo\\volt',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('velocity','\\metre\\per\\second',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('t_delta','\\kelvin',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('mass_flow','\\kilo\\gram\\per\\second',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('volume_flow','\\cubicmetre\\per\\second','\\cubicmetre\\per\\hour','\\deci\\cubicmetre\\per\\second','\\deci\\cubicmetre\\per\\minute',NULL,NULL,NULL);
INSERT INTO `units` VALUES ('no_unit','-',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('heat_conductivity','\\watt\\per\\metre\\usk\\kelvin',NULL,NULL,NULL,NULL,'\\watt\\per\\metre\\kelvin',NULL);
INSERT INTO `units` VALUES ('heat_transfer','\\watt\\per\\squaremetre\\usk\\kelvin',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('heat_flux_density','\\watt\\per\\squaremetre',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('amperage','\\ampere',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('absolute_humidity','\\gram\\per\\kilo\\gram',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('thermal_expansion','1\\per\\kelvin','10^{-6}\\per\\kelvin',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('spec_heat_flow','\\watt\\per\\kilo\\gram\\usk\\second','\\kilo\\joule\\per\\kilo\\gram\\usk\\dday','',NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('volume_energy','\\kilo\\joule\\per\\cubicmetre',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('radiation_const','\\watt\\per\\squaremetre\\kelvin^4',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('gwp','\\kilo\\gram_{\\mathrm{CO_{2}}}\\per\\kilo\\gram_{\\mathrm{R}}',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('leakage','\\kilo\\gram_{\\mathrm{R}}\\per \\hspace{0.2ex}\\mathrm{a}',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('emission_per_energy','\\kilo\\gram_{\\mathrm{CO_{2}}}\\per\\kilo\\watt\\hour',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('energy_year','\\joule\\per{}\\hspace{-0.2ex}\\mathrm{a}','\\kilo\\joule\\per{}\\hspace{-0.2ex}\\mathrm{a}','\\kilo\\watt\\hour\\per{}\\hspace{-0.2ex}\\mathrm{a}',NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('tewi','\\kilo\\gram_{\\mathrm{CO_{2}}}',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('temperature_c','\\celsius','','',NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('temperature_f','\\ensuremath{^\\circ}\\mathrm{F}','','',NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('temperature_k','\\kelvin','','',NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('spec_energy_vol','\\joule\\per\\cubicmetre','\\kilo\\joule\\per\\cubicmetre',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('spring_const','\\newton\\per\\metre',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('resistance','\\ohm',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('conductance','\\siemens',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('resistivity','\\ohm\\usk\\milli\\squaremetre\\per\\metre',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('conductivity','\\metre\\per\\ohm\\usk\\milli\\squaremetre',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('inductance','\\henry','\\volt\\second\\per\\ampere',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('capacitance','\\farad','\\ampere\\second\\per\\volt',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('charge','\\coulomb','\\ampere\\second',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('dielectric_const',' \\ampere\\usk\\second\\per\\volt\\usk\\metre',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('percent','\\%',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('torque','\\newton\\metre',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('angle','\\degree',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('temperature_compensation_slope','1\\per\\kelvin',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('power_apparent','\\volt\\ampere',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('power_reactive','\\var','\\kilo\\joule\\per\\second',NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('money','\\text{\\euro}',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('money_per_work','\\text{\\euro}\\per\\kilo\\watt\\hour',NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `units` VALUES ('lenght','\\metre','\\deci\\metre','\\centi\\metre','\\milli\\metre',NULL,NULL,NULL);
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `vocabulary`
--

DROP TABLE IF EXISTS `vocabulary`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vocabulary` (
  `Lexikon` tinyint(1) NOT NULL DEFAULT '1',
  `de` varchar(255) NOT NULL DEFAULT '',
  `en` varchar(255) NOT NULL DEFAULT '',
  `it` varchar(255) NOT NULL DEFAULT '',
  `fr` varchar(255) NOT NULL DEFAULT '',
  `ps_diag` tinyint(4) NOT NULL DEFAULT '0',
  `psfrag` tinyint(4) NOT NULL DEFAULT '0',
  `tagname` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`de`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='Translation of used Words';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `vocabulary`
--

LOCK TABLES `vocabulary` WRITE;
/*!40000 ALTER TABLE `vocabulary` DISABLE KEYS */;
INSERT INTO `vocabulary` VALUES (0,'in','in','','en',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verdampferberechnung','Evaporator Calculation','','Calculation evaporique(geraten)',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Enthalpie','Enthalpy','Entalpia','',1,0,'');
INSERT INTO `vocabulary` VALUES (1,'Druck','Pressure','Pressione','',1,0,'');
INSERT INTO `vocabulary` VALUES (1,'Formel-zeichen','Symbol','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Beschreibung','Description','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Einheiten','Units','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Gewichtskraft','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Masse und Volumen','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Mechanische Arbeit','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Mechanische Leistung','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Fleisch','Meat','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Fisch','Fish','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Molkereiprodukte','Dairy products','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Sonstige Kühlgüter','Other Products','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Gemüse','Vegetables','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Obst','Fruit','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'frisch','fresh','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'gefroren','frozen','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Flüssigkeiten','Liquids','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Dämmstoffe','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Metalle','Metals','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Formelsammlung','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Gase','Gases','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Baustoffe','Construction Materials','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wirkungsgrad','Efficiency','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Volumenstrom','Volume Flow','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Strömungsgeschwindigkeit','Flow Velocity','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Massenstrom','Mass Flow','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Kontinuitätsgleichung','Law of Continuity','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Hydrostatischer Druck','Hydrostatic Pressure','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Druckverluste in Rohrleitungen','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Temperatur','Temperature','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Ausdehnung bei Temperaturänderung','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Gasgesetze','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Boyle-Mariotte (konstante Temperatur)','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Allgemeines Gasgesetz','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wärmelehre (Kalorimetrie)','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Erwärmen/Abkühlen','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verdampfen/Kondensieren','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Schmelzen/Erstarren','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wärmestrom','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Abkühlen und Gefrieren von Kühlgut','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Mischen von Stoffen','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Feuchte Luft','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Kältebedarf und Kälteleistung','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Beleuchtungswärmestrom','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Personenwärmestrom','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Abtauwärmestrom','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Ventilatorwärmestrom','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Erforderliche Kälteleistung einer Kälteanlage','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Elektromotor','','','',0,1,'');
INSERT INTO `vocabulary` VALUES (1,'Getriebe','','','',0,1,'');
INSERT INTO `vocabulary` VALUES (1,'Verdichter','','','',0,1,'');
INSERT INTO `vocabulary` VALUES (0,'\\large \\bf Innenseite','','','',0,1,'Innen');
INSERT INTO `vocabulary` VALUES (0,'\\large Mauerwerk','','','',0,1,'Mauer');
INSERT INTO `vocabulary` VALUES (0,'\\large \\bf Außenseite','','','',0,1,'Aussen');
INSERT INTO `vocabulary` VALUES (0,'\\large Dämmung','','','',0,1,'Iso');
INSERT INTO `vocabulary` VALUES (1,'Grundlagen','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Arbeit, Energie und Leistung','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Strömungslehre','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Thermodynamik','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wärmeübertrager','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verdampfer','Evaporator','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verflüssiger','Condenser','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Expansionsventil','Expansion Valve','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Leistungszahlen','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Leistungszahl','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Gütegrade','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Kältemaschine','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wärmepumpe','Heat Pump','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wärmedurchgang','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Hubvolumen','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Riemengetriebe','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verdichtungsprozess','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Atmungswärmestrom','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wärmestromdichte','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Kaltdampfprozess','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Prozess im log\\,p,\\,h-Diagramm','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Mittlere logarithmische Temperaturdifferenz','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verdampferoberfläche','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Oberfläche eines Glattrohres','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Oberfläche der Lamellen','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Oberfläche des Lamellenverdampfers','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Luftkühler','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Flüssigkeitskühler','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verdichterleistungen und Wirkungsgrade','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Ventilatorleistung','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Luftgekühlt','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Flüssigkeitsgekühlt','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verflüssigeroberfläche','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'siehe Verdampfer','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Energetische Beurteilung des Kaltdampfprozesses','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'siehe Wärmeübertrager','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wärmeübertragung','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verflüssigungsprozess','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verdampfungsprozess','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verdampferleistung (Kühlmediumseitig)','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verdampferleistung aus Konstruktionsdaten','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verflüssigerleistung aus Konstruktionsdaten','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Verflüssigerleistung (Abwärmeseitig)','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wärmestrahlung','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Barometrische Höhenformel','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Sonderfälle','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Strahlungsaustausch einer Fläche (1) mit ihrer Umhüllung (2)','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Stefan-Boltzmannsches Gesetz','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Heizungsrohr in einem großen Raum','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Parallele unendlich große Platten','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Innenrohr in Mantelrohr mit geringem Abstand','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Elektrotechnik','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Kältemittel','Refrigerants','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wärmeleitung','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wärmeübergang (Konvektion)','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (0,'Mechanische Energie','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Typischer Wert','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Elektrische Grundbegriffe','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Widerstandsschaltungen','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Grundlagen des Wechselstroms','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Spule und Kondensator','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wechselstromkreis','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Drehstrom','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Wechselstrom','','','',0,0,'');
INSERT INTO `vocabulary` VALUES (1,'Ventilatoren','','','',0,1,'');
/*!40000 ALTER TABLE `vocabulary` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2017-09-29 18:30:56
